/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ebs;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ebs.AmazonEBS;
import com.amazonaws.services.ebs.AmazonEBSClientBuilder;
import com.amazonaws.services.ebs.model.AmazonEBSException;
import com.amazonaws.services.ebs.model.CompleteSnapshotRequest;
import com.amazonaws.services.ebs.model.CompleteSnapshotResult;
import com.amazonaws.services.ebs.model.GetSnapshotBlockRequest;
import com.amazonaws.services.ebs.model.GetSnapshotBlockResult;
import com.amazonaws.services.ebs.model.ListChangedBlocksRequest;
import com.amazonaws.services.ebs.model.ListChangedBlocksResult;
import com.amazonaws.services.ebs.model.ListSnapshotBlocksRequest;
import com.amazonaws.services.ebs.model.ListSnapshotBlocksResult;
import com.amazonaws.services.ebs.model.PutSnapshotBlockRequest;
import com.amazonaws.services.ebs.model.PutSnapshotBlockResult;
import com.amazonaws.services.ebs.model.StartSnapshotRequest;
import com.amazonaws.services.ebs.model.StartSnapshotResult;
import com.amazonaws.services.ebs.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.ebs.model.transform.CompleteSnapshotRequestProtocolMarshaller;
import com.amazonaws.services.ebs.model.transform.CompleteSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.ebs.model.transform.ConcurrentLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.ebs.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.ebs.model.transform.GetSnapshotBlockRequestProtocolMarshaller;
import com.amazonaws.services.ebs.model.transform.GetSnapshotBlockResultJsonUnmarshaller;
import com.amazonaws.services.ebs.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ebs.model.transform.ListChangedBlocksRequestProtocolMarshaller;
import com.amazonaws.services.ebs.model.transform.ListChangedBlocksResultJsonUnmarshaller;
import com.amazonaws.services.ebs.model.transform.ListSnapshotBlocksRequestProtocolMarshaller;
import com.amazonaws.services.ebs.model.transform.ListSnapshotBlocksResultJsonUnmarshaller;
import com.amazonaws.services.ebs.model.transform.PutSnapshotBlockRequestProtocolMarshaller;
import com.amazonaws.services.ebs.model.transform.PutSnapshotBlockResultJsonUnmarshaller;
import com.amazonaws.services.ebs.model.transform.RequestThrottledExceptionUnmarshaller;
import com.amazonaws.services.ebs.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ebs.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.ebs.model.transform.StartSnapshotRequestProtocolMarshaller;
import com.amazonaws.services.ebs.model.transform.StartSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.ebs.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonEBSClient
extends AmazonWebServiceClient
implements AmazonEBS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonEBS.class);
    private static final String DEFAULT_SIGNING_NAME = "ebs";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestThrottledException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestThrottledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonEBSException.class));

    public static AmazonEBSClientBuilder builder() {
        return AmazonEBSClientBuilder.standard();
    }

    AmazonEBSClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonEBSClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ebs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ebs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ebs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CompleteSnapshotResult completeSnapshot(CompleteSnapshotRequest request) {
        request = (CompleteSnapshotRequest)this.beforeClientExecution(request);
        return this.executeCompleteSnapshot(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CompleteSnapshotResult executeCompleteSnapshot(CompleteSnapshotRequest completeSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteSnapshotRequestProtocolMarshaller(protocolFactory).marshall((CompleteSnapshotRequest)super.beforeMarshalling((AmazonWebServiceRequest)completeSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EBS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CompleteSnapshot");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompleteSnapshotResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CompleteSnapshotResult completeSnapshotResult = (CompleteSnapshotResult)response.getAwsResponse();
            return completeSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSnapshotBlockResult getSnapshotBlock(GetSnapshotBlockRequest request) {
        request = (GetSnapshotBlockRequest)this.beforeClientExecution(request);
        return this.executeGetSnapshotBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSnapshotBlockResult executeGetSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSnapshotBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSnapshotBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSnapshotBlockRequestProtocolMarshaller(protocolFactory).marshall((GetSnapshotBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSnapshotBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EBS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSnapshotBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetSnapshotBlockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            GetSnapshotBlockResult getSnapshotBlockResult = (GetSnapshotBlockResult)response.getAwsResponse();
            return getSnapshotBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChangedBlocksResult listChangedBlocks(ListChangedBlocksRequest request) {
        request = (ListChangedBlocksRequest)this.beforeClientExecution(request);
        return this.executeListChangedBlocks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChangedBlocksResult executeListChangedBlocks(ListChangedBlocksRequest listChangedBlocksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChangedBlocksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChangedBlocksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChangedBlocksRequestProtocolMarshaller(protocolFactory).marshall((ListChangedBlocksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChangedBlocksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EBS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChangedBlocks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChangedBlocksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChangedBlocksResult listChangedBlocksResult = (ListChangedBlocksResult)response.getAwsResponse();
            return listChangedBlocksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSnapshotBlocksResult listSnapshotBlocks(ListSnapshotBlocksRequest request) {
        request = (ListSnapshotBlocksRequest)this.beforeClientExecution(request);
        return this.executeListSnapshotBlocks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSnapshotBlocksResult executeListSnapshotBlocks(ListSnapshotBlocksRequest listSnapshotBlocksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSnapshotBlocksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSnapshotBlocksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSnapshotBlocksRequestProtocolMarshaller(protocolFactory).marshall((ListSnapshotBlocksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSnapshotBlocksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EBS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSnapshotBlocks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSnapshotBlocksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSnapshotBlocksResult listSnapshotBlocksResult = (ListSnapshotBlocksResult)response.getAwsResponse();
            return listSnapshotBlocksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutSnapshotBlockResult putSnapshotBlock(PutSnapshotBlockRequest request) {
        request = (PutSnapshotBlockRequest)this.beforeClientExecution(request);
        return this.executePutSnapshotBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutSnapshotBlockResult executePutSnapshotBlock(PutSnapshotBlockRequest putSnapshotBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putSnapshotBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutSnapshotBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutSnapshotBlockRequestProtocolMarshaller(protocolFactory).marshall((PutSnapshotBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)putSnapshotBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EBS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutSnapshotBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, (Object)Boolean.TRUE);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutSnapshotBlockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutSnapshotBlockResult putSnapshotBlockResult = (PutSnapshotBlockResult)response.getAwsResponse();
            return putSnapshotBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSnapshotResult startSnapshot(StartSnapshotRequest request) {
        request = (StartSnapshotRequest)this.beforeClientExecution(request);
        return this.executeStartSnapshot(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSnapshotResult executeStartSnapshot(StartSnapshotRequest startSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSnapshotRequestProtocolMarshaller(protocolFactory).marshall((StartSnapshotRequest)super.beforeMarshalling((AmazonWebServiceRequest)startSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EBS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartSnapshot");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSnapshotResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSnapshotResult startSnapshotResult = (StartSnapshotResult)response.getAwsResponse();
            return startSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

