/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.IndexStatus;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.OnDemandThroughput;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GlobalSecondaryIndexDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String indexName;
    private List<KeySchemaElement> keySchema;
    private Projection projection;
    private String indexStatus;
    private Boolean backfilling;
    private ProvisionedThroughputDescription provisionedThroughput;
    private Long indexSizeBytes;
    private Long itemCount;
    private String indexArn;
    private OnDemandThroughput onDemandThroughput;

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public GlobalSecondaryIndexDescription withIndexName(String indexName) {
        this.setIndexName(indexName);
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        this.keySchema = new ArrayList<KeySchemaElement>(keySchema);
    }

    public GlobalSecondaryIndexDescription withKeySchema(KeySchemaElement ... keySchema) {
        if (this.keySchema == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement ele : keySchema) {
            this.keySchema.add(ele);
        }
        return this;
    }

    public GlobalSecondaryIndexDescription withKeySchema(Collection<KeySchemaElement> keySchema) {
        this.setKeySchema(keySchema);
        return this;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public GlobalSecondaryIndexDescription withProjection(Projection projection) {
        this.setProjection(projection);
        return this;
    }

    public void setIndexStatus(String indexStatus) {
        this.indexStatus = indexStatus;
    }

    public String getIndexStatus() {
        return this.indexStatus;
    }

    public GlobalSecondaryIndexDescription withIndexStatus(String indexStatus) {
        this.setIndexStatus(indexStatus);
        return this;
    }

    public void setIndexStatus(IndexStatus indexStatus) {
        this.withIndexStatus(indexStatus);
    }

    public GlobalSecondaryIndexDescription withIndexStatus(IndexStatus indexStatus) {
        this.indexStatus = indexStatus.toString();
        return this;
    }

    public void setBackfilling(Boolean backfilling) {
        this.backfilling = backfilling;
    }

    public Boolean getBackfilling() {
        return this.backfilling;
    }

    public GlobalSecondaryIndexDescription withBackfilling(Boolean backfilling) {
        this.setBackfilling(backfilling);
        return this;
    }

    public Boolean isBackfilling() {
        return this.backfilling;
    }

    public void setProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public ProvisionedThroughputDescription getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public GlobalSecondaryIndexDescription withProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
        this.setProvisionedThroughput(provisionedThroughput);
        return this;
    }

    public void setIndexSizeBytes(Long indexSizeBytes) {
        this.indexSizeBytes = indexSizeBytes;
    }

    public Long getIndexSizeBytes() {
        return this.indexSizeBytes;
    }

    public GlobalSecondaryIndexDescription withIndexSizeBytes(Long indexSizeBytes) {
        this.setIndexSizeBytes(indexSizeBytes);
        return this;
    }

    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public GlobalSecondaryIndexDescription withItemCount(Long itemCount) {
        this.setItemCount(itemCount);
        return this;
    }

    public void setIndexArn(String indexArn) {
        this.indexArn = indexArn;
    }

    public String getIndexArn() {
        return this.indexArn;
    }

    public GlobalSecondaryIndexDescription withIndexArn(String indexArn) {
        this.setIndexArn(indexArn);
        return this;
    }

    public void setOnDemandThroughput(OnDemandThroughput onDemandThroughput) {
        this.onDemandThroughput = onDemandThroughput;
    }

    public OnDemandThroughput getOnDemandThroughput() {
        return this.onDemandThroughput;
    }

    public GlobalSecondaryIndexDescription withOnDemandThroughput(OnDemandThroughput onDemandThroughput) {
        this.setOnDemandThroughput(onDemandThroughput);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexName() != null) {
            sb.append("IndexName: ").append(this.getIndexName()).append(",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: ").append(this.getKeySchema()).append(",");
        }
        if (this.getProjection() != null) {
            sb.append("Projection: ").append(this.getProjection()).append(",");
        }
        if (this.getIndexStatus() != null) {
            sb.append("IndexStatus: ").append(this.getIndexStatus()).append(",");
        }
        if (this.getBackfilling() != null) {
            sb.append("Backfilling: ").append(this.getBackfilling()).append(",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.getProvisionedThroughput()).append(",");
        }
        if (this.getIndexSizeBytes() != null) {
            sb.append("IndexSizeBytes: ").append(this.getIndexSizeBytes()).append(",");
        }
        if (this.getItemCount() != null) {
            sb.append("ItemCount: ").append(this.getItemCount()).append(",");
        }
        if (this.getIndexArn() != null) {
            sb.append("IndexArn: ").append(this.getIndexArn()).append(",");
        }
        if (this.getOnDemandThroughput() != null) {
            sb.append("OnDemandThroughput: ").append(this.getOnDemandThroughput());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexDescription)) {
            return false;
        }
        GlobalSecondaryIndexDescription other = (GlobalSecondaryIndexDescription)obj;
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        if (other.getProjection() != null && !other.getProjection().equals(this.getProjection())) {
            return false;
        }
        if (other.getIndexStatus() == null ^ this.getIndexStatus() == null) {
            return false;
        }
        if (other.getIndexStatus() != null && !other.getIndexStatus().equals(this.getIndexStatus())) {
            return false;
        }
        if (other.getBackfilling() == null ^ this.getBackfilling() == null) {
            return false;
        }
        if (other.getBackfilling() != null && !other.getBackfilling().equals(this.getBackfilling())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (other.getProvisionedThroughput() != null && !other.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (other.getIndexSizeBytes() == null ^ this.getIndexSizeBytes() == null) {
            return false;
        }
        if (other.getIndexSizeBytes() != null && !other.getIndexSizeBytes().equals(this.getIndexSizeBytes())) {
            return false;
        }
        if (other.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        if (other.getItemCount() != null && !other.getItemCount().equals(this.getItemCount())) {
            return false;
        }
        if (other.getIndexArn() == null ^ this.getIndexArn() == null) {
            return false;
        }
        if (other.getIndexArn() != null && !other.getIndexArn().equals(this.getIndexArn())) {
            return false;
        }
        if (other.getOnDemandThroughput() == null ^ this.getOnDemandThroughput() == null) {
            return false;
        }
        return other.getOnDemandThroughput() == null || other.getOnDemandThroughput().equals(this.getOnDemandThroughput());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        hashCode = 31 * hashCode + (this.getIndexStatus() == null ? 0 : this.getIndexStatus().hashCode());
        hashCode = 31 * hashCode + (this.getBackfilling() == null ? 0 : this.getBackfilling().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getIndexSizeBytes() == null ? 0 : this.getIndexSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        hashCode = 31 * hashCode + (this.getIndexArn() == null ? 0 : this.getIndexArn().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandThroughput() == null ? 0 : this.getOnDemandThroughput().hashCode());
        return hashCode;
    }

    public GlobalSecondaryIndexDescription clone() {
        try {
            return (GlobalSecondaryIndexDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalSecondaryIndexDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

