/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.drs.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopSourceNetworkReplication" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StopSourceNetworkReplicationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Source Network which was requested to stop replication.
     * </p>
     */
    private SourceNetwork sourceNetwork;

    /**
     * <p>
     * Source Network which was requested to stop replication.
     * </p>
     * 
     * @param sourceNetwork
     *        Source Network which was requested to stop replication.
     */

    public void setSourceNetwork(SourceNetwork sourceNetwork) {
        this.sourceNetwork = sourceNetwork;
    }

    /**
     * <p>
     * Source Network which was requested to stop replication.
     * </p>
     * 
     * @return Source Network which was requested to stop replication.
     */

    public SourceNetwork getSourceNetwork() {
        return this.sourceNetwork;
    }

    /**
     * <p>
     * Source Network which was requested to stop replication.
     * </p>
     * 
     * @param sourceNetwork
     *        Source Network which was requested to stop replication.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StopSourceNetworkReplicationResult withSourceNetwork(SourceNetwork sourceNetwork) {
        setSourceNetwork(sourceNetwork);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSourceNetwork() != null)
            sb.append("SourceNetwork: ").append(getSourceNetwork());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StopSourceNetworkReplicationResult == false)
            return false;
        StopSourceNetworkReplicationResult other = (StopSourceNetworkReplicationResult) obj;
        if (other.getSourceNetwork() == null ^ this.getSourceNetwork() == null)
            return false;
        if (other.getSourceNetwork() != null && other.getSourceNetwork().equals(this.getSourceNetwork()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSourceNetwork() == null) ? 0 : getSourceNetwork().hashCode());
        return hashCode;
    }

    @Override
    public StopSourceNetworkReplicationResult clone() {
        try {
            return (StopSourceNetworkReplicationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
