/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.drs.model.SourceNetwork;
import java.util.Map;

@SdkInternalApi
public class SourceNetworkMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> CFNSTACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cfnStackName").build();
    private static final MarshallingInfo<StructuredPojo> LASTRECOVERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastRecovery").build();
    private static final MarshallingInfo<String> LAUNCHEDVPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchedVpcID").build();
    private static final MarshallingInfo<String> REPLICATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationStatus").build();
    private static final MarshallingInfo<String> REPLICATIONSTATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationStatusDetails").build();
    private static final MarshallingInfo<String> SOURCEACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceAccountID").build();
    private static final MarshallingInfo<String> SOURCENETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceNetworkID").build();
    private static final MarshallingInfo<String> SOURCEREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceRegion").build();
    private static final MarshallingInfo<String> SOURCEVPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVpcID").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final SourceNetworkMarshaller instance = new SourceNetworkMarshaller();

    public static SourceNetworkMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceNetwork sourceNetwork, ProtocolMarshaller protocolMarshaller) {
        if (sourceNetwork == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sourceNetwork.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getCfnStackName(), CFNSTACKNAME_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getLastRecovery(), LASTRECOVERY_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getLaunchedVpcID(), LAUNCHEDVPCID_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getReplicationStatus(), REPLICATIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getReplicationStatusDetails(), REPLICATIONSTATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getSourceAccountID(), SOURCEACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getSourceNetworkID(), SOURCENETWORKID_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getSourceRegion(), SOURCEREGION_BINDING);
            protocolMarshaller.marshall((Object)sourceNetwork.getSourceVpcID(), SOURCEVPCID_BINDING);
            protocolMarshaller.marshall(sourceNetwork.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

