/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.drs.AWSdrsAsync;
import com.amazonaws.services.drs.AWSdrsAsyncClientBuilder;
import com.amazonaws.services.drs.AWSdrsClient;
import com.amazonaws.services.drs.model.AssociateSourceNetworkStackRequest;
import com.amazonaws.services.drs.model.AssociateSourceNetworkStackResult;
import com.amazonaws.services.drs.model.CreateExtendedSourceServerRequest;
import com.amazonaws.services.drs.model.CreateExtendedSourceServerResult;
import com.amazonaws.services.drs.model.CreateLaunchConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.CreateLaunchConfigurationTemplateResult;
import com.amazonaws.services.drs.model.CreateReplicationConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.CreateReplicationConfigurationTemplateResult;
import com.amazonaws.services.drs.model.CreateSourceNetworkRequest;
import com.amazonaws.services.drs.model.CreateSourceNetworkResult;
import com.amazonaws.services.drs.model.DeleteJobRequest;
import com.amazonaws.services.drs.model.DeleteJobResult;
import com.amazonaws.services.drs.model.DeleteLaunchConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.DeleteLaunchConfigurationTemplateResult;
import com.amazonaws.services.drs.model.DeleteRecoveryInstanceRequest;
import com.amazonaws.services.drs.model.DeleteRecoveryInstanceResult;
import com.amazonaws.services.drs.model.DeleteReplicationConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.DeleteReplicationConfigurationTemplateResult;
import com.amazonaws.services.drs.model.DeleteSourceNetworkRequest;
import com.amazonaws.services.drs.model.DeleteSourceNetworkResult;
import com.amazonaws.services.drs.model.DeleteSourceServerRequest;
import com.amazonaws.services.drs.model.DeleteSourceServerResult;
import com.amazonaws.services.drs.model.DescribeJobLogItemsRequest;
import com.amazonaws.services.drs.model.DescribeJobLogItemsResult;
import com.amazonaws.services.drs.model.DescribeJobsRequest;
import com.amazonaws.services.drs.model.DescribeJobsResult;
import com.amazonaws.services.drs.model.DescribeLaunchConfigurationTemplatesRequest;
import com.amazonaws.services.drs.model.DescribeLaunchConfigurationTemplatesResult;
import com.amazonaws.services.drs.model.DescribeRecoveryInstancesRequest;
import com.amazonaws.services.drs.model.DescribeRecoveryInstancesResult;
import com.amazonaws.services.drs.model.DescribeRecoverySnapshotsRequest;
import com.amazonaws.services.drs.model.DescribeRecoverySnapshotsResult;
import com.amazonaws.services.drs.model.DescribeReplicationConfigurationTemplatesRequest;
import com.amazonaws.services.drs.model.DescribeReplicationConfigurationTemplatesResult;
import com.amazonaws.services.drs.model.DescribeSourceNetworksRequest;
import com.amazonaws.services.drs.model.DescribeSourceNetworksResult;
import com.amazonaws.services.drs.model.DescribeSourceServersRequest;
import com.amazonaws.services.drs.model.DescribeSourceServersResult;
import com.amazonaws.services.drs.model.DisconnectRecoveryInstanceRequest;
import com.amazonaws.services.drs.model.DisconnectRecoveryInstanceResult;
import com.amazonaws.services.drs.model.DisconnectSourceServerRequest;
import com.amazonaws.services.drs.model.DisconnectSourceServerResult;
import com.amazonaws.services.drs.model.ExportSourceNetworkCfnTemplateRequest;
import com.amazonaws.services.drs.model.ExportSourceNetworkCfnTemplateResult;
import com.amazonaws.services.drs.model.GetFailbackReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.GetFailbackReplicationConfigurationResult;
import com.amazonaws.services.drs.model.GetLaunchConfigurationRequest;
import com.amazonaws.services.drs.model.GetLaunchConfigurationResult;
import com.amazonaws.services.drs.model.GetReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.GetReplicationConfigurationResult;
import com.amazonaws.services.drs.model.InitializeServiceRequest;
import com.amazonaws.services.drs.model.InitializeServiceResult;
import com.amazonaws.services.drs.model.ListExtensibleSourceServersRequest;
import com.amazonaws.services.drs.model.ListExtensibleSourceServersResult;
import com.amazonaws.services.drs.model.ListStagingAccountsRequest;
import com.amazonaws.services.drs.model.ListStagingAccountsResult;
import com.amazonaws.services.drs.model.ListTagsForResourceRequest;
import com.amazonaws.services.drs.model.ListTagsForResourceResult;
import com.amazonaws.services.drs.model.RetryDataReplicationRequest;
import com.amazonaws.services.drs.model.RetryDataReplicationResult;
import com.amazonaws.services.drs.model.ReverseReplicationRequest;
import com.amazonaws.services.drs.model.ReverseReplicationResult;
import com.amazonaws.services.drs.model.StartFailbackLaunchRequest;
import com.amazonaws.services.drs.model.StartFailbackLaunchResult;
import com.amazonaws.services.drs.model.StartRecoveryRequest;
import com.amazonaws.services.drs.model.StartRecoveryResult;
import com.amazonaws.services.drs.model.StartReplicationRequest;
import com.amazonaws.services.drs.model.StartReplicationResult;
import com.amazonaws.services.drs.model.StartSourceNetworkRecoveryRequest;
import com.amazonaws.services.drs.model.StartSourceNetworkRecoveryResult;
import com.amazonaws.services.drs.model.StartSourceNetworkReplicationRequest;
import com.amazonaws.services.drs.model.StartSourceNetworkReplicationResult;
import com.amazonaws.services.drs.model.StopFailbackRequest;
import com.amazonaws.services.drs.model.StopFailbackResult;
import com.amazonaws.services.drs.model.StopReplicationRequest;
import com.amazonaws.services.drs.model.StopReplicationResult;
import com.amazonaws.services.drs.model.StopSourceNetworkReplicationRequest;
import com.amazonaws.services.drs.model.StopSourceNetworkReplicationResult;
import com.amazonaws.services.drs.model.TagResourceRequest;
import com.amazonaws.services.drs.model.TagResourceResult;
import com.amazonaws.services.drs.model.TerminateRecoveryInstancesRequest;
import com.amazonaws.services.drs.model.TerminateRecoveryInstancesResult;
import com.amazonaws.services.drs.model.UntagResourceRequest;
import com.amazonaws.services.drs.model.UntagResourceResult;
import com.amazonaws.services.drs.model.UpdateFailbackReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.UpdateFailbackReplicationConfigurationResult;
import com.amazonaws.services.drs.model.UpdateLaunchConfigurationRequest;
import com.amazonaws.services.drs.model.UpdateLaunchConfigurationResult;
import com.amazonaws.services.drs.model.UpdateLaunchConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.UpdateLaunchConfigurationTemplateResult;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationResult;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationTemplateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSdrsAsyncClient
extends AWSdrsClient
implements AWSdrsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSdrsAsyncClientBuilder asyncBuilder() {
        return AWSdrsAsyncClientBuilder.standard();
    }

    AWSdrsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSdrsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateSourceNetworkStackResult> associateSourceNetworkStackAsync(AssociateSourceNetworkStackRequest request) {
        return this.associateSourceNetworkStackAsync(request, null);
    }

    @Override
    public Future<AssociateSourceNetworkStackResult> associateSourceNetworkStackAsync(AssociateSourceNetworkStackRequest request, final AsyncHandler<AssociateSourceNetworkStackRequest, AssociateSourceNetworkStackResult> asyncHandler) {
        final AssociateSourceNetworkStackRequest finalRequest = (AssociateSourceNetworkStackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateSourceNetworkStackResult>(){

            @Override
            public AssociateSourceNetworkStackResult call() throws Exception {
                AssociateSourceNetworkStackResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeAssociateSourceNetworkStack(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateExtendedSourceServerResult> createExtendedSourceServerAsync(CreateExtendedSourceServerRequest request) {
        return this.createExtendedSourceServerAsync(request, null);
    }

    @Override
    public Future<CreateExtendedSourceServerResult> createExtendedSourceServerAsync(CreateExtendedSourceServerRequest request, final AsyncHandler<CreateExtendedSourceServerRequest, CreateExtendedSourceServerResult> asyncHandler) {
        final CreateExtendedSourceServerRequest finalRequest = (CreateExtendedSourceServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateExtendedSourceServerResult>(){

            @Override
            public CreateExtendedSourceServerResult call() throws Exception {
                CreateExtendedSourceServerResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeCreateExtendedSourceServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLaunchConfigurationTemplateResult> createLaunchConfigurationTemplateAsync(CreateLaunchConfigurationTemplateRequest request) {
        return this.createLaunchConfigurationTemplateAsync(request, null);
    }

    @Override
    public Future<CreateLaunchConfigurationTemplateResult> createLaunchConfigurationTemplateAsync(CreateLaunchConfigurationTemplateRequest request, final AsyncHandler<CreateLaunchConfigurationTemplateRequest, CreateLaunchConfigurationTemplateResult> asyncHandler) {
        final CreateLaunchConfigurationTemplateRequest finalRequest = (CreateLaunchConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLaunchConfigurationTemplateResult>(){

            @Override
            public CreateLaunchConfigurationTemplateResult call() throws Exception {
                CreateLaunchConfigurationTemplateResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeCreateLaunchConfigurationTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateReplicationConfigurationTemplateResult> createReplicationConfigurationTemplateAsync(CreateReplicationConfigurationTemplateRequest request) {
        return this.createReplicationConfigurationTemplateAsync(request, null);
    }

    @Override
    public Future<CreateReplicationConfigurationTemplateResult> createReplicationConfigurationTemplateAsync(CreateReplicationConfigurationTemplateRequest request, final AsyncHandler<CreateReplicationConfigurationTemplateRequest, CreateReplicationConfigurationTemplateResult> asyncHandler) {
        final CreateReplicationConfigurationTemplateRequest finalRequest = (CreateReplicationConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateReplicationConfigurationTemplateResult>(){

            @Override
            public CreateReplicationConfigurationTemplateResult call() throws Exception {
                CreateReplicationConfigurationTemplateResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeCreateReplicationConfigurationTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSourceNetworkResult> createSourceNetworkAsync(CreateSourceNetworkRequest request) {
        return this.createSourceNetworkAsync(request, null);
    }

    @Override
    public Future<CreateSourceNetworkResult> createSourceNetworkAsync(CreateSourceNetworkRequest request, final AsyncHandler<CreateSourceNetworkRequest, CreateSourceNetworkResult> asyncHandler) {
        final CreateSourceNetworkRequest finalRequest = (CreateSourceNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSourceNetworkResult>(){

            @Override
            public CreateSourceNetworkResult call() throws Exception {
                CreateSourceNetworkResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeCreateSourceNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteJobResult> deleteJobAsync(DeleteJobRequest request) {
        return this.deleteJobAsync(request, null);
    }

    @Override
    public Future<DeleteJobResult> deleteJobAsync(DeleteJobRequest request, final AsyncHandler<DeleteJobRequest, DeleteJobResult> asyncHandler) {
        final DeleteJobRequest finalRequest = (DeleteJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteJobResult>(){

            @Override
            public DeleteJobResult call() throws Exception {
                DeleteJobResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDeleteJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLaunchConfigurationTemplateResult> deleteLaunchConfigurationTemplateAsync(DeleteLaunchConfigurationTemplateRequest request) {
        return this.deleteLaunchConfigurationTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteLaunchConfigurationTemplateResult> deleteLaunchConfigurationTemplateAsync(DeleteLaunchConfigurationTemplateRequest request, final AsyncHandler<DeleteLaunchConfigurationTemplateRequest, DeleteLaunchConfigurationTemplateResult> asyncHandler) {
        final DeleteLaunchConfigurationTemplateRequest finalRequest = (DeleteLaunchConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLaunchConfigurationTemplateResult>(){

            @Override
            public DeleteLaunchConfigurationTemplateResult call() throws Exception {
                DeleteLaunchConfigurationTemplateResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDeleteLaunchConfigurationTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRecoveryInstanceResult> deleteRecoveryInstanceAsync(DeleteRecoveryInstanceRequest request) {
        return this.deleteRecoveryInstanceAsync(request, null);
    }

    @Override
    public Future<DeleteRecoveryInstanceResult> deleteRecoveryInstanceAsync(DeleteRecoveryInstanceRequest request, final AsyncHandler<DeleteRecoveryInstanceRequest, DeleteRecoveryInstanceResult> asyncHandler) {
        final DeleteRecoveryInstanceRequest finalRequest = (DeleteRecoveryInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRecoveryInstanceResult>(){

            @Override
            public DeleteRecoveryInstanceResult call() throws Exception {
                DeleteRecoveryInstanceResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDeleteRecoveryInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteReplicationConfigurationTemplateResult> deleteReplicationConfigurationTemplateAsync(DeleteReplicationConfigurationTemplateRequest request) {
        return this.deleteReplicationConfigurationTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteReplicationConfigurationTemplateResult> deleteReplicationConfigurationTemplateAsync(DeleteReplicationConfigurationTemplateRequest request, final AsyncHandler<DeleteReplicationConfigurationTemplateRequest, DeleteReplicationConfigurationTemplateResult> asyncHandler) {
        final DeleteReplicationConfigurationTemplateRequest finalRequest = (DeleteReplicationConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteReplicationConfigurationTemplateResult>(){

            @Override
            public DeleteReplicationConfigurationTemplateResult call() throws Exception {
                DeleteReplicationConfigurationTemplateResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDeleteReplicationConfigurationTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSourceNetworkResult> deleteSourceNetworkAsync(DeleteSourceNetworkRequest request) {
        return this.deleteSourceNetworkAsync(request, null);
    }

    @Override
    public Future<DeleteSourceNetworkResult> deleteSourceNetworkAsync(DeleteSourceNetworkRequest request, final AsyncHandler<DeleteSourceNetworkRequest, DeleteSourceNetworkResult> asyncHandler) {
        final DeleteSourceNetworkRequest finalRequest = (DeleteSourceNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSourceNetworkResult>(){

            @Override
            public DeleteSourceNetworkResult call() throws Exception {
                DeleteSourceNetworkResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDeleteSourceNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSourceServerResult> deleteSourceServerAsync(DeleteSourceServerRequest request) {
        return this.deleteSourceServerAsync(request, null);
    }

    @Override
    public Future<DeleteSourceServerResult> deleteSourceServerAsync(DeleteSourceServerRequest request, final AsyncHandler<DeleteSourceServerRequest, DeleteSourceServerResult> asyncHandler) {
        final DeleteSourceServerRequest finalRequest = (DeleteSourceServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSourceServerResult>(){

            @Override
            public DeleteSourceServerResult call() throws Exception {
                DeleteSourceServerResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDeleteSourceServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobLogItemsResult> describeJobLogItemsAsync(DescribeJobLogItemsRequest request) {
        return this.describeJobLogItemsAsync(request, null);
    }

    @Override
    public Future<DescribeJobLogItemsResult> describeJobLogItemsAsync(DescribeJobLogItemsRequest request, final AsyncHandler<DescribeJobLogItemsRequest, DescribeJobLogItemsResult> asyncHandler) {
        final DescribeJobLogItemsRequest finalRequest = (DescribeJobLogItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobLogItemsResult>(){

            @Override
            public DescribeJobLogItemsResult call() throws Exception {
                DescribeJobLogItemsResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeJobLogItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobsResult> describeJobsAsync(DescribeJobsRequest request) {
        return this.describeJobsAsync(request, null);
    }

    @Override
    public Future<DescribeJobsResult> describeJobsAsync(DescribeJobsRequest request, final AsyncHandler<DescribeJobsRequest, DescribeJobsResult> asyncHandler) {
        final DescribeJobsRequest finalRequest = (DescribeJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobsResult>(){

            @Override
            public DescribeJobsResult call() throws Exception {
                DescribeJobsResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLaunchConfigurationTemplatesResult> describeLaunchConfigurationTemplatesAsync(DescribeLaunchConfigurationTemplatesRequest request) {
        return this.describeLaunchConfigurationTemplatesAsync(request, null);
    }

    @Override
    public Future<DescribeLaunchConfigurationTemplatesResult> describeLaunchConfigurationTemplatesAsync(DescribeLaunchConfigurationTemplatesRequest request, final AsyncHandler<DescribeLaunchConfigurationTemplatesRequest, DescribeLaunchConfigurationTemplatesResult> asyncHandler) {
        final DescribeLaunchConfigurationTemplatesRequest finalRequest = (DescribeLaunchConfigurationTemplatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLaunchConfigurationTemplatesResult>(){

            @Override
            public DescribeLaunchConfigurationTemplatesResult call() throws Exception {
                DescribeLaunchConfigurationTemplatesResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeLaunchConfigurationTemplates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRecoveryInstancesResult> describeRecoveryInstancesAsync(DescribeRecoveryInstancesRequest request) {
        return this.describeRecoveryInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeRecoveryInstancesResult> describeRecoveryInstancesAsync(DescribeRecoveryInstancesRequest request, final AsyncHandler<DescribeRecoveryInstancesRequest, DescribeRecoveryInstancesResult> asyncHandler) {
        final DescribeRecoveryInstancesRequest finalRequest = (DescribeRecoveryInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRecoveryInstancesResult>(){

            @Override
            public DescribeRecoveryInstancesResult call() throws Exception {
                DescribeRecoveryInstancesResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeRecoveryInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRecoverySnapshotsResult> describeRecoverySnapshotsAsync(DescribeRecoverySnapshotsRequest request) {
        return this.describeRecoverySnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeRecoverySnapshotsResult> describeRecoverySnapshotsAsync(DescribeRecoverySnapshotsRequest request, final AsyncHandler<DescribeRecoverySnapshotsRequest, DescribeRecoverySnapshotsResult> asyncHandler) {
        final DescribeRecoverySnapshotsRequest finalRequest = (DescribeRecoverySnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRecoverySnapshotsResult>(){

            @Override
            public DescribeRecoverySnapshotsResult call() throws Exception {
                DescribeRecoverySnapshotsResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeRecoverySnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReplicationConfigurationTemplatesResult> describeReplicationConfigurationTemplatesAsync(DescribeReplicationConfigurationTemplatesRequest request) {
        return this.describeReplicationConfigurationTemplatesAsync(request, null);
    }

    @Override
    public Future<DescribeReplicationConfigurationTemplatesResult> describeReplicationConfigurationTemplatesAsync(DescribeReplicationConfigurationTemplatesRequest request, final AsyncHandler<DescribeReplicationConfigurationTemplatesRequest, DescribeReplicationConfigurationTemplatesResult> asyncHandler) {
        final DescribeReplicationConfigurationTemplatesRequest finalRequest = (DescribeReplicationConfigurationTemplatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReplicationConfigurationTemplatesResult>(){

            @Override
            public DescribeReplicationConfigurationTemplatesResult call() throws Exception {
                DescribeReplicationConfigurationTemplatesResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeReplicationConfigurationTemplates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSourceNetworksResult> describeSourceNetworksAsync(DescribeSourceNetworksRequest request) {
        return this.describeSourceNetworksAsync(request, null);
    }

    @Override
    public Future<DescribeSourceNetworksResult> describeSourceNetworksAsync(DescribeSourceNetworksRequest request, final AsyncHandler<DescribeSourceNetworksRequest, DescribeSourceNetworksResult> asyncHandler) {
        final DescribeSourceNetworksRequest finalRequest = (DescribeSourceNetworksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSourceNetworksResult>(){

            @Override
            public DescribeSourceNetworksResult call() throws Exception {
                DescribeSourceNetworksResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeSourceNetworks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSourceServersResult> describeSourceServersAsync(DescribeSourceServersRequest request) {
        return this.describeSourceServersAsync(request, null);
    }

    @Override
    public Future<DescribeSourceServersResult> describeSourceServersAsync(DescribeSourceServersRequest request, final AsyncHandler<DescribeSourceServersRequest, DescribeSourceServersResult> asyncHandler) {
        final DescribeSourceServersRequest finalRequest = (DescribeSourceServersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSourceServersResult>(){

            @Override
            public DescribeSourceServersResult call() throws Exception {
                DescribeSourceServersResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDescribeSourceServers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisconnectRecoveryInstanceResult> disconnectRecoveryInstanceAsync(DisconnectRecoveryInstanceRequest request) {
        return this.disconnectRecoveryInstanceAsync(request, null);
    }

    @Override
    public Future<DisconnectRecoveryInstanceResult> disconnectRecoveryInstanceAsync(DisconnectRecoveryInstanceRequest request, final AsyncHandler<DisconnectRecoveryInstanceRequest, DisconnectRecoveryInstanceResult> asyncHandler) {
        final DisconnectRecoveryInstanceRequest finalRequest = (DisconnectRecoveryInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisconnectRecoveryInstanceResult>(){

            @Override
            public DisconnectRecoveryInstanceResult call() throws Exception {
                DisconnectRecoveryInstanceResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDisconnectRecoveryInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisconnectSourceServerResult> disconnectSourceServerAsync(DisconnectSourceServerRequest request) {
        return this.disconnectSourceServerAsync(request, null);
    }

    @Override
    public Future<DisconnectSourceServerResult> disconnectSourceServerAsync(DisconnectSourceServerRequest request, final AsyncHandler<DisconnectSourceServerRequest, DisconnectSourceServerResult> asyncHandler) {
        final DisconnectSourceServerRequest finalRequest = (DisconnectSourceServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisconnectSourceServerResult>(){

            @Override
            public DisconnectSourceServerResult call() throws Exception {
                DisconnectSourceServerResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeDisconnectSourceServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportSourceNetworkCfnTemplateResult> exportSourceNetworkCfnTemplateAsync(ExportSourceNetworkCfnTemplateRequest request) {
        return this.exportSourceNetworkCfnTemplateAsync(request, null);
    }

    @Override
    public Future<ExportSourceNetworkCfnTemplateResult> exportSourceNetworkCfnTemplateAsync(ExportSourceNetworkCfnTemplateRequest request, final AsyncHandler<ExportSourceNetworkCfnTemplateRequest, ExportSourceNetworkCfnTemplateResult> asyncHandler) {
        final ExportSourceNetworkCfnTemplateRequest finalRequest = (ExportSourceNetworkCfnTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportSourceNetworkCfnTemplateResult>(){

            @Override
            public ExportSourceNetworkCfnTemplateResult call() throws Exception {
                ExportSourceNetworkCfnTemplateResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeExportSourceNetworkCfnTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFailbackReplicationConfigurationResult> getFailbackReplicationConfigurationAsync(GetFailbackReplicationConfigurationRequest request) {
        return this.getFailbackReplicationConfigurationAsync(request, null);
    }

    @Override
    public Future<GetFailbackReplicationConfigurationResult> getFailbackReplicationConfigurationAsync(GetFailbackReplicationConfigurationRequest request, final AsyncHandler<GetFailbackReplicationConfigurationRequest, GetFailbackReplicationConfigurationResult> asyncHandler) {
        final GetFailbackReplicationConfigurationRequest finalRequest = (GetFailbackReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFailbackReplicationConfigurationResult>(){

            @Override
            public GetFailbackReplicationConfigurationResult call() throws Exception {
                GetFailbackReplicationConfigurationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeGetFailbackReplicationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLaunchConfigurationResult> getLaunchConfigurationAsync(GetLaunchConfigurationRequest request) {
        return this.getLaunchConfigurationAsync(request, null);
    }

    @Override
    public Future<GetLaunchConfigurationResult> getLaunchConfigurationAsync(GetLaunchConfigurationRequest request, final AsyncHandler<GetLaunchConfigurationRequest, GetLaunchConfigurationResult> asyncHandler) {
        final GetLaunchConfigurationRequest finalRequest = (GetLaunchConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLaunchConfigurationResult>(){

            @Override
            public GetLaunchConfigurationResult call() throws Exception {
                GetLaunchConfigurationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeGetLaunchConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReplicationConfigurationResult> getReplicationConfigurationAsync(GetReplicationConfigurationRequest request) {
        return this.getReplicationConfigurationAsync(request, null);
    }

    @Override
    public Future<GetReplicationConfigurationResult> getReplicationConfigurationAsync(GetReplicationConfigurationRequest request, final AsyncHandler<GetReplicationConfigurationRequest, GetReplicationConfigurationResult> asyncHandler) {
        final GetReplicationConfigurationRequest finalRequest = (GetReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReplicationConfigurationResult>(){

            @Override
            public GetReplicationConfigurationResult call() throws Exception {
                GetReplicationConfigurationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeGetReplicationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitializeServiceResult> initializeServiceAsync(InitializeServiceRequest request) {
        return this.initializeServiceAsync(request, null);
    }

    @Override
    public Future<InitializeServiceResult> initializeServiceAsync(InitializeServiceRequest request, final AsyncHandler<InitializeServiceRequest, InitializeServiceResult> asyncHandler) {
        final InitializeServiceRequest finalRequest = (InitializeServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InitializeServiceResult>(){

            @Override
            public InitializeServiceResult call() throws Exception {
                InitializeServiceResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeInitializeService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExtensibleSourceServersResult> listExtensibleSourceServersAsync(ListExtensibleSourceServersRequest request) {
        return this.listExtensibleSourceServersAsync(request, null);
    }

    @Override
    public Future<ListExtensibleSourceServersResult> listExtensibleSourceServersAsync(ListExtensibleSourceServersRequest request, final AsyncHandler<ListExtensibleSourceServersRequest, ListExtensibleSourceServersResult> asyncHandler) {
        final ListExtensibleSourceServersRequest finalRequest = (ListExtensibleSourceServersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExtensibleSourceServersResult>(){

            @Override
            public ListExtensibleSourceServersResult call() throws Exception {
                ListExtensibleSourceServersResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeListExtensibleSourceServers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStagingAccountsResult> listStagingAccountsAsync(ListStagingAccountsRequest request) {
        return this.listStagingAccountsAsync(request, null);
    }

    @Override
    public Future<ListStagingAccountsResult> listStagingAccountsAsync(ListStagingAccountsRequest request, final AsyncHandler<ListStagingAccountsRequest, ListStagingAccountsResult> asyncHandler) {
        final ListStagingAccountsRequest finalRequest = (ListStagingAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStagingAccountsResult>(){

            @Override
            public ListStagingAccountsResult call() throws Exception {
                ListStagingAccountsResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeListStagingAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<RetryDataReplicationResult> retryDataReplicationAsync(RetryDataReplicationRequest request) {
        return this.retryDataReplicationAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<RetryDataReplicationResult> retryDataReplicationAsync(RetryDataReplicationRequest request, final AsyncHandler<RetryDataReplicationRequest, RetryDataReplicationResult> asyncHandler) {
        final RetryDataReplicationRequest finalRequest = (RetryDataReplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RetryDataReplicationResult>(){

            @Override
            public RetryDataReplicationResult call() throws Exception {
                RetryDataReplicationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeRetryDataReplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReverseReplicationResult> reverseReplicationAsync(ReverseReplicationRequest request) {
        return this.reverseReplicationAsync(request, null);
    }

    @Override
    public Future<ReverseReplicationResult> reverseReplicationAsync(ReverseReplicationRequest request, final AsyncHandler<ReverseReplicationRequest, ReverseReplicationResult> asyncHandler) {
        final ReverseReplicationRequest finalRequest = (ReverseReplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReverseReplicationResult>(){

            @Override
            public ReverseReplicationResult call() throws Exception {
                ReverseReplicationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeReverseReplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFailbackLaunchResult> startFailbackLaunchAsync(StartFailbackLaunchRequest request) {
        return this.startFailbackLaunchAsync(request, null);
    }

    @Override
    public Future<StartFailbackLaunchResult> startFailbackLaunchAsync(StartFailbackLaunchRequest request, final AsyncHandler<StartFailbackLaunchRequest, StartFailbackLaunchResult> asyncHandler) {
        final StartFailbackLaunchRequest finalRequest = (StartFailbackLaunchRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFailbackLaunchResult>(){

            @Override
            public StartFailbackLaunchResult call() throws Exception {
                StartFailbackLaunchResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStartFailbackLaunch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartRecoveryResult> startRecoveryAsync(StartRecoveryRequest request) {
        return this.startRecoveryAsync(request, null);
    }

    @Override
    public Future<StartRecoveryResult> startRecoveryAsync(StartRecoveryRequest request, final AsyncHandler<StartRecoveryRequest, StartRecoveryResult> asyncHandler) {
        final StartRecoveryRequest finalRequest = (StartRecoveryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartRecoveryResult>(){

            @Override
            public StartRecoveryResult call() throws Exception {
                StartRecoveryResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStartRecovery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartReplicationResult> startReplicationAsync(StartReplicationRequest request) {
        return this.startReplicationAsync(request, null);
    }

    @Override
    public Future<StartReplicationResult> startReplicationAsync(StartReplicationRequest request, final AsyncHandler<StartReplicationRequest, StartReplicationResult> asyncHandler) {
        final StartReplicationRequest finalRequest = (StartReplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartReplicationResult>(){

            @Override
            public StartReplicationResult call() throws Exception {
                StartReplicationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStartReplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSourceNetworkRecoveryResult> startSourceNetworkRecoveryAsync(StartSourceNetworkRecoveryRequest request) {
        return this.startSourceNetworkRecoveryAsync(request, null);
    }

    @Override
    public Future<StartSourceNetworkRecoveryResult> startSourceNetworkRecoveryAsync(StartSourceNetworkRecoveryRequest request, final AsyncHandler<StartSourceNetworkRecoveryRequest, StartSourceNetworkRecoveryResult> asyncHandler) {
        final StartSourceNetworkRecoveryRequest finalRequest = (StartSourceNetworkRecoveryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSourceNetworkRecoveryResult>(){

            @Override
            public StartSourceNetworkRecoveryResult call() throws Exception {
                StartSourceNetworkRecoveryResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStartSourceNetworkRecovery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSourceNetworkReplicationResult> startSourceNetworkReplicationAsync(StartSourceNetworkReplicationRequest request) {
        return this.startSourceNetworkReplicationAsync(request, null);
    }

    @Override
    public Future<StartSourceNetworkReplicationResult> startSourceNetworkReplicationAsync(StartSourceNetworkReplicationRequest request, final AsyncHandler<StartSourceNetworkReplicationRequest, StartSourceNetworkReplicationResult> asyncHandler) {
        final StartSourceNetworkReplicationRequest finalRequest = (StartSourceNetworkReplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSourceNetworkReplicationResult>(){

            @Override
            public StartSourceNetworkReplicationResult call() throws Exception {
                StartSourceNetworkReplicationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStartSourceNetworkReplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopFailbackResult> stopFailbackAsync(StopFailbackRequest request) {
        return this.stopFailbackAsync(request, null);
    }

    @Override
    public Future<StopFailbackResult> stopFailbackAsync(StopFailbackRequest request, final AsyncHandler<StopFailbackRequest, StopFailbackResult> asyncHandler) {
        final StopFailbackRequest finalRequest = (StopFailbackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopFailbackResult>(){

            @Override
            public StopFailbackResult call() throws Exception {
                StopFailbackResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStopFailback(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopReplicationResult> stopReplicationAsync(StopReplicationRequest request) {
        return this.stopReplicationAsync(request, null);
    }

    @Override
    public Future<StopReplicationResult> stopReplicationAsync(StopReplicationRequest request, final AsyncHandler<StopReplicationRequest, StopReplicationResult> asyncHandler) {
        final StopReplicationRequest finalRequest = (StopReplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopReplicationResult>(){

            @Override
            public StopReplicationResult call() throws Exception {
                StopReplicationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStopReplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopSourceNetworkReplicationResult> stopSourceNetworkReplicationAsync(StopSourceNetworkReplicationRequest request) {
        return this.stopSourceNetworkReplicationAsync(request, null);
    }

    @Override
    public Future<StopSourceNetworkReplicationResult> stopSourceNetworkReplicationAsync(StopSourceNetworkReplicationRequest request, final AsyncHandler<StopSourceNetworkReplicationRequest, StopSourceNetworkReplicationResult> asyncHandler) {
        final StopSourceNetworkReplicationRequest finalRequest = (StopSourceNetworkReplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopSourceNetworkReplicationResult>(){

            @Override
            public StopSourceNetworkReplicationResult call() throws Exception {
                StopSourceNetworkReplicationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeStopSourceNetworkReplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateRecoveryInstancesResult> terminateRecoveryInstancesAsync(TerminateRecoveryInstancesRequest request) {
        return this.terminateRecoveryInstancesAsync(request, null);
    }

    @Override
    public Future<TerminateRecoveryInstancesResult> terminateRecoveryInstancesAsync(TerminateRecoveryInstancesRequest request, final AsyncHandler<TerminateRecoveryInstancesRequest, TerminateRecoveryInstancesResult> asyncHandler) {
        final TerminateRecoveryInstancesRequest finalRequest = (TerminateRecoveryInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TerminateRecoveryInstancesResult>(){

            @Override
            public TerminateRecoveryInstancesResult call() throws Exception {
                TerminateRecoveryInstancesResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeTerminateRecoveryInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFailbackReplicationConfigurationResult> updateFailbackReplicationConfigurationAsync(UpdateFailbackReplicationConfigurationRequest request) {
        return this.updateFailbackReplicationConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateFailbackReplicationConfigurationResult> updateFailbackReplicationConfigurationAsync(UpdateFailbackReplicationConfigurationRequest request, final AsyncHandler<UpdateFailbackReplicationConfigurationRequest, UpdateFailbackReplicationConfigurationResult> asyncHandler) {
        final UpdateFailbackReplicationConfigurationRequest finalRequest = (UpdateFailbackReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFailbackReplicationConfigurationResult>(){

            @Override
            public UpdateFailbackReplicationConfigurationResult call() throws Exception {
                UpdateFailbackReplicationConfigurationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeUpdateFailbackReplicationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLaunchConfigurationResult> updateLaunchConfigurationAsync(UpdateLaunchConfigurationRequest request) {
        return this.updateLaunchConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateLaunchConfigurationResult> updateLaunchConfigurationAsync(UpdateLaunchConfigurationRequest request, final AsyncHandler<UpdateLaunchConfigurationRequest, UpdateLaunchConfigurationResult> asyncHandler) {
        final UpdateLaunchConfigurationRequest finalRequest = (UpdateLaunchConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLaunchConfigurationResult>(){

            @Override
            public UpdateLaunchConfigurationResult call() throws Exception {
                UpdateLaunchConfigurationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeUpdateLaunchConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLaunchConfigurationTemplateResult> updateLaunchConfigurationTemplateAsync(UpdateLaunchConfigurationTemplateRequest request) {
        return this.updateLaunchConfigurationTemplateAsync(request, null);
    }

    @Override
    public Future<UpdateLaunchConfigurationTemplateResult> updateLaunchConfigurationTemplateAsync(UpdateLaunchConfigurationTemplateRequest request, final AsyncHandler<UpdateLaunchConfigurationTemplateRequest, UpdateLaunchConfigurationTemplateResult> asyncHandler) {
        final UpdateLaunchConfigurationTemplateRequest finalRequest = (UpdateLaunchConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLaunchConfigurationTemplateResult>(){

            @Override
            public UpdateLaunchConfigurationTemplateResult call() throws Exception {
                UpdateLaunchConfigurationTemplateResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeUpdateLaunchConfigurationTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateReplicationConfigurationResult> updateReplicationConfigurationAsync(UpdateReplicationConfigurationRequest request) {
        return this.updateReplicationConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateReplicationConfigurationResult> updateReplicationConfigurationAsync(UpdateReplicationConfigurationRequest request, final AsyncHandler<UpdateReplicationConfigurationRequest, UpdateReplicationConfigurationResult> asyncHandler) {
        final UpdateReplicationConfigurationRequest finalRequest = (UpdateReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateReplicationConfigurationResult>(){

            @Override
            public UpdateReplicationConfigurationResult call() throws Exception {
                UpdateReplicationConfigurationResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeUpdateReplicationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateReplicationConfigurationTemplateResult> updateReplicationConfigurationTemplateAsync(UpdateReplicationConfigurationTemplateRequest request) {
        return this.updateReplicationConfigurationTemplateAsync(request, null);
    }

    @Override
    public Future<UpdateReplicationConfigurationTemplateResult> updateReplicationConfigurationTemplateAsync(UpdateReplicationConfigurationTemplateRequest request, final AsyncHandler<UpdateReplicationConfigurationTemplateRequest, UpdateReplicationConfigurationTemplateResult> asyncHandler) {
        final UpdateReplicationConfigurationTemplateRequest finalRequest = (UpdateReplicationConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateReplicationConfigurationTemplateResult>(){

            @Override
            public UpdateReplicationConfigurationTemplateResult call() throws Exception {
                UpdateReplicationConfigurationTemplateResult result = null;
                try {
                    result = AWSdrsAsyncClient.this.executeUpdateReplicationConfigurationTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

