/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.drs.model.transform.RecoverySnapshotMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecoverySnapshot
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> ebsSnapshots;
    private String expectedTimestamp;
    private String snapshotID;
    private String sourceServerID;
    private String timestamp;

    public List<String> getEbsSnapshots() {
        return this.ebsSnapshots;
    }

    public void setEbsSnapshots(Collection<String> ebsSnapshots) {
        if (ebsSnapshots == null) {
            this.ebsSnapshots = null;
            return;
        }
        this.ebsSnapshots = new ArrayList<String>(ebsSnapshots);
    }

    public RecoverySnapshot withEbsSnapshots(String ... ebsSnapshots) {
        if (this.ebsSnapshots == null) {
            this.setEbsSnapshots(new ArrayList<String>(ebsSnapshots.length));
        }
        for (String ele : ebsSnapshots) {
            this.ebsSnapshots.add(ele);
        }
        return this;
    }

    public RecoverySnapshot withEbsSnapshots(Collection<String> ebsSnapshots) {
        this.setEbsSnapshots(ebsSnapshots);
        return this;
    }

    public void setExpectedTimestamp(String expectedTimestamp) {
        this.expectedTimestamp = expectedTimestamp;
    }

    public String getExpectedTimestamp() {
        return this.expectedTimestamp;
    }

    public RecoverySnapshot withExpectedTimestamp(String expectedTimestamp) {
        this.setExpectedTimestamp(expectedTimestamp);
        return this;
    }

    public void setSnapshotID(String snapshotID) {
        this.snapshotID = snapshotID;
    }

    public String getSnapshotID() {
        return this.snapshotID;
    }

    public RecoverySnapshot withSnapshotID(String snapshotID) {
        this.setSnapshotID(snapshotID);
        return this;
    }

    public void setSourceServerID(String sourceServerID) {
        this.sourceServerID = sourceServerID;
    }

    public String getSourceServerID() {
        return this.sourceServerID;
    }

    public RecoverySnapshot withSourceServerID(String sourceServerID) {
        this.setSourceServerID(sourceServerID);
        return this;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public RecoverySnapshot withTimestamp(String timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEbsSnapshots() != null) {
            sb.append("EbsSnapshots: ").append(this.getEbsSnapshots()).append(",");
        }
        if (this.getExpectedTimestamp() != null) {
            sb.append("ExpectedTimestamp: ").append(this.getExpectedTimestamp()).append(",");
        }
        if (this.getSnapshotID() != null) {
            sb.append("SnapshotID: ").append(this.getSnapshotID()).append(",");
        }
        if (this.getSourceServerID() != null) {
            sb.append("SourceServerID: ").append(this.getSourceServerID()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoverySnapshot)) {
            return false;
        }
        RecoverySnapshot other = (RecoverySnapshot)obj;
        if (other.getEbsSnapshots() == null ^ this.getEbsSnapshots() == null) {
            return false;
        }
        if (other.getEbsSnapshots() != null && !other.getEbsSnapshots().equals(this.getEbsSnapshots())) {
            return false;
        }
        if (other.getExpectedTimestamp() == null ^ this.getExpectedTimestamp() == null) {
            return false;
        }
        if (other.getExpectedTimestamp() != null && !other.getExpectedTimestamp().equals(this.getExpectedTimestamp())) {
            return false;
        }
        if (other.getSnapshotID() == null ^ this.getSnapshotID() == null) {
            return false;
        }
        if (other.getSnapshotID() != null && !other.getSnapshotID().equals(this.getSnapshotID())) {
            return false;
        }
        if (other.getSourceServerID() == null ^ this.getSourceServerID() == null) {
            return false;
        }
        if (other.getSourceServerID() != null && !other.getSourceServerID().equals(this.getSourceServerID())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        return other.getTimestamp() == null || other.getTimestamp().equals(this.getTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEbsSnapshots() == null ? 0 : this.getEbsSnapshots().hashCode());
        hashCode = 31 * hashCode + (this.getExpectedTimestamp() == null ? 0 : this.getExpectedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotID() == null ? 0 : this.getSnapshotID().hashCode());
        hashCode = 31 * hashCode + (this.getSourceServerID() == null ? 0 : this.getSourceServerID().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        return hashCode;
    }

    public RecoverySnapshot clone() {
        try {
            return (RecoverySnapshot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecoverySnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

