/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model;

import com.amazonaws.services.docdb.model.DBInstanceStatusInfo;
import com.amazonaws.services.docdb.model.DBSubnetGroup;
import com.amazonaws.services.docdb.model.Endpoint;
import com.amazonaws.services.docdb.model.PendingModifiedValues;
import com.amazonaws.services.docdb.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DBInstance
implements Serializable,
Cloneable {
    private String dBInstanceIdentifier;
    private String dBInstanceClass;
    private String engine;
    private String dBInstanceStatus;
    private Endpoint endpoint;
    private Date instanceCreateTime;
    private String preferredBackupWindow;
    private Integer backupRetentionPeriod;
    private List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private String availabilityZone;
    private DBSubnetGroup dBSubnetGroup;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private Date latestRestorableTime;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private Boolean publiclyAccessible;
    private List<DBInstanceStatusInfo> statusInfos;
    private String dBClusterIdentifier;
    private Boolean storageEncrypted;
    private String kmsKeyId;
    private String dbiResourceId;
    private String cACertificateIdentifier;
    private Boolean copyTagsToSnapshot;
    private Integer promotionTier;
    private String dBInstanceArn;
    private List<String> enabledCloudwatchLogsExports;

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public DBInstance withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.setDBInstanceIdentifier(dBInstanceIdentifier);
        return this;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public DBInstance withDBInstanceClass(String dBInstanceClass) {
        this.setDBInstanceClass(dBInstanceClass);
        return this;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public DBInstance withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setDBInstanceStatus(String dBInstanceStatus) {
        this.dBInstanceStatus = dBInstanceStatus;
    }

    public String getDBInstanceStatus() {
        return this.dBInstanceStatus;
    }

    public DBInstance withDBInstanceStatus(String dBInstanceStatus) {
        this.setDBInstanceStatus(dBInstanceStatus);
        return this;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public DBInstance withEndpoint(Endpoint endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setInstanceCreateTime(Date instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
    }

    public Date getInstanceCreateTime() {
        return this.instanceCreateTime;
    }

    public DBInstance withInstanceCreateTime(Date instanceCreateTime) {
        this.setInstanceCreateTime(instanceCreateTime);
        return this;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public DBInstance withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public DBInstance withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.setBackupRetentionPeriod(backupRetentionPeriod);
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        this.vpcSecurityGroups = new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroups);
    }

    public DBInstance withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.vpcSecurityGroups == null) {
            this.setVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership ele : vpcSecurityGroups) {
            this.vpcSecurityGroups.add(ele);
        }
        return this;
    }

    public DBInstance withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        this.setVpcSecurityGroups(vpcSecurityGroups);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public DBInstance withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
    }

    public DBSubnetGroup getDBSubnetGroup() {
        return this.dBSubnetGroup;
    }

    public DBInstance withDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.setDBSubnetGroup(dBSubnetGroup);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public DBInstance withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public DBInstance withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public DBInstance withLatestRestorableTime(Date latestRestorableTime) {
        this.setLatestRestorableTime(latestRestorableTime);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public DBInstance withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public DBInstance withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public DBInstance withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<DBInstanceStatusInfo> getStatusInfos() {
        return this.statusInfos;
    }

    public void setStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
        if (statusInfos == null) {
            this.statusInfos = null;
            return;
        }
        this.statusInfos = new ArrayList<DBInstanceStatusInfo>(statusInfos);
    }

    public DBInstance withStatusInfos(DBInstanceStatusInfo ... statusInfos) {
        if (this.statusInfos == null) {
            this.setStatusInfos(new ArrayList<DBInstanceStatusInfo>(statusInfos.length));
        }
        for (DBInstanceStatusInfo ele : statusInfos) {
            this.statusInfos.add(ele);
        }
        return this;
    }

    public DBInstance withStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
        this.setStatusInfos(statusInfos);
        return this;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public DBInstance withDBClusterIdentifier(String dBClusterIdentifier) {
        this.setDBClusterIdentifier(dBClusterIdentifier);
        return this;
    }

    public void setStorageEncrypted(Boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }

    public Boolean getStorageEncrypted() {
        return this.storageEncrypted;
    }

    public DBInstance withStorageEncrypted(Boolean storageEncrypted) {
        this.setStorageEncrypted(storageEncrypted);
        return this;
    }

    public Boolean isStorageEncrypted() {
        return this.storageEncrypted;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public DBInstance withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setDbiResourceId(String dbiResourceId) {
        this.dbiResourceId = dbiResourceId;
    }

    public String getDbiResourceId() {
        return this.dbiResourceId;
    }

    public DBInstance withDbiResourceId(String dbiResourceId) {
        this.setDbiResourceId(dbiResourceId);
        return this;
    }

    public void setCACertificateIdentifier(String cACertificateIdentifier) {
        this.cACertificateIdentifier = cACertificateIdentifier;
    }

    public String getCACertificateIdentifier() {
        return this.cACertificateIdentifier;
    }

    public DBInstance withCACertificateIdentifier(String cACertificateIdentifier) {
        this.setCACertificateIdentifier(cACertificateIdentifier);
        return this;
    }

    public void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public Boolean getCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public DBInstance withCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.setCopyTagsToSnapshot(copyTagsToSnapshot);
        return this;
    }

    public Boolean isCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public void setPromotionTier(Integer promotionTier) {
        this.promotionTier = promotionTier;
    }

    public Integer getPromotionTier() {
        return this.promotionTier;
    }

    public DBInstance withPromotionTier(Integer promotionTier) {
        this.setPromotionTier(promotionTier);
        return this;
    }

    public void setDBInstanceArn(String dBInstanceArn) {
        this.dBInstanceArn = dBInstanceArn;
    }

    public String getDBInstanceArn() {
        return this.dBInstanceArn;
    }

    public DBInstance withDBInstanceArn(String dBInstanceArn) {
        this.setDBInstanceArn(dBInstanceArn);
        return this;
    }

    public List<String> getEnabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports;
    }

    public void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
        if (enabledCloudwatchLogsExports == null) {
            this.enabledCloudwatchLogsExports = null;
            return;
        }
        this.enabledCloudwatchLogsExports = new ArrayList<String>(enabledCloudwatchLogsExports);
    }

    public DBInstance withEnabledCloudwatchLogsExports(String ... enabledCloudwatchLogsExports) {
        if (this.enabledCloudwatchLogsExports == null) {
            this.setEnabledCloudwatchLogsExports(new ArrayList<String>(enabledCloudwatchLogsExports.length));
        }
        for (String ele : enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports.add(ele);
        }
        return this;
    }

    public DBInstance withEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
        this.setEnabledCloudwatchLogsExports(enabledCloudwatchLogsExports);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.getDBInstanceIdentifier()).append(",");
        }
        if (this.getDBInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.getDBInstanceClass()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getDBInstanceStatus() != null) {
            sb.append("DBInstanceStatus: ").append(this.getDBInstanceStatus()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getInstanceCreateTime() != null) {
            sb.append("InstanceCreateTime: ").append(this.getInstanceCreateTime()).append(",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.getPreferredBackupWindow()).append(",");
        }
        if (this.getBackupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.getBackupRetentionPeriod()).append(",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.getVpcSecurityGroups()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getDBSubnetGroup() != null) {
            sb.append("DBSubnetGroup: ").append(this.getDBSubnetGroup()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getLatestRestorableTime() != null) {
            sb.append("LatestRestorableTime: ").append(this.getLatestRestorableTime()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getStatusInfos() != null) {
            sb.append("StatusInfos: ").append(this.getStatusInfos()).append(",");
        }
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.getDBClusterIdentifier()).append(",");
        }
        if (this.getStorageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.getStorageEncrypted()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getDbiResourceId() != null) {
            sb.append("DbiResourceId: ").append(this.getDbiResourceId()).append(",");
        }
        if (this.getCACertificateIdentifier() != null) {
            sb.append("CACertificateIdentifier: ").append(this.getCACertificateIdentifier()).append(",");
        }
        if (this.getCopyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.getCopyTagsToSnapshot()).append(",");
        }
        if (this.getPromotionTier() != null) {
            sb.append("PromotionTier: ").append(this.getPromotionTier()).append(",");
        }
        if (this.getDBInstanceArn() != null) {
            sb.append("DBInstanceArn: ").append(this.getDBInstanceArn()).append(",");
        }
        if (this.getEnabledCloudwatchLogsExports() != null) {
            sb.append("EnabledCloudwatchLogsExports: ").append(this.getEnabledCloudwatchLogsExports());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance)obj;
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getDBInstanceStatus() == null ^ this.getDBInstanceStatus() == null) {
            return false;
        }
        if (other.getDBInstanceStatus() != null && !other.getDBInstanceStatus().equals(this.getDBInstanceStatus())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getInstanceCreateTime() == null ^ this.getInstanceCreateTime() == null) {
            return false;
        }
        if (other.getInstanceCreateTime() != null && !other.getInstanceCreateTime().equals(this.getInstanceCreateTime())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDBSubnetGroup() == null ^ this.getDBSubnetGroup() == null) {
            return false;
        }
        if (other.getDBSubnetGroup() != null && !other.getDBSubnetGroup().equals(this.getDBSubnetGroup())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getStatusInfos() == null ^ this.getStatusInfos() == null) {
            return false;
        }
        if (other.getStatusInfos() != null && !other.getStatusInfos().equals(this.getStatusInfos())) {
            return false;
        }
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getStorageEncrypted() == null ^ this.getStorageEncrypted() == null) {
            return false;
        }
        if (other.getStorageEncrypted() != null && !other.getStorageEncrypted().equals(this.getStorageEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getDbiResourceId() == null ^ this.getDbiResourceId() == null) {
            return false;
        }
        if (other.getDbiResourceId() != null && !other.getDbiResourceId().equals(this.getDbiResourceId())) {
            return false;
        }
        if (other.getCACertificateIdentifier() == null ^ this.getCACertificateIdentifier() == null) {
            return false;
        }
        if (other.getCACertificateIdentifier() != null && !other.getCACertificateIdentifier().equals(this.getCACertificateIdentifier())) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() == null ^ this.getCopyTagsToSnapshot() == null) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() != null && !other.getCopyTagsToSnapshot().equals(this.getCopyTagsToSnapshot())) {
            return false;
        }
        if (other.getPromotionTier() == null ^ this.getPromotionTier() == null) {
            return false;
        }
        if (other.getPromotionTier() != null && !other.getPromotionTier().equals(this.getPromotionTier())) {
            return false;
        }
        if (other.getDBInstanceArn() == null ^ this.getDBInstanceArn() == null) {
            return false;
        }
        if (other.getDBInstanceArn() != null && !other.getDBInstanceArn().equals(this.getDBInstanceArn())) {
            return false;
        }
        if (other.getEnabledCloudwatchLogsExports() == null ^ this.getEnabledCloudwatchLogsExports() == null) {
            return false;
        }
        return other.getEnabledCloudwatchLogsExports() == null || other.getEnabledCloudwatchLogsExports().equals(this.getEnabledCloudwatchLogsExports());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceStatus() == null ? 0 : this.getDBInstanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCreateTime() == null ? 0 : this.getInstanceCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroup() == null ? 0 : this.getDBSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getStatusInfos() == null ? 0 : this.getStatusInfos().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getStorageEncrypted() == null ? 0 : this.getStorageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getDbiResourceId() == null ? 0 : this.getDbiResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getCACertificateIdentifier() == null ? 0 : this.getCACertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToSnapshot() == null ? 0 : this.getCopyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.getPromotionTier() == null ? 0 : this.getPromotionTier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceArn() == null ? 0 : this.getDBInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledCloudwatchLogsExports() == null ? 0 : this.getEnabledCloudwatchLogsExports().hashCode());
        return hashCode;
    }

    public DBInstance clone() {
        try {
            return (DBInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

