/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.databasemigrationservice.model.ReloadOptionValue;
import com.amazonaws.services.databasemigrationservice.model.TableToReload;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReloadReplicationTablesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String replicationConfigArn;
    private List<TableToReload> tablesToReload;
    private String reloadOption;

    public void setReplicationConfigArn(String replicationConfigArn) {
        this.replicationConfigArn = replicationConfigArn;
    }

    public String getReplicationConfigArn() {
        return this.replicationConfigArn;
    }

    public ReloadReplicationTablesRequest withReplicationConfigArn(String replicationConfigArn) {
        this.setReplicationConfigArn(replicationConfigArn);
        return this;
    }

    public List<TableToReload> getTablesToReload() {
        return this.tablesToReload;
    }

    public void setTablesToReload(Collection<TableToReload> tablesToReload) {
        if (tablesToReload == null) {
            this.tablesToReload = null;
            return;
        }
        this.tablesToReload = new ArrayList<TableToReload>(tablesToReload);
    }

    public ReloadReplicationTablesRequest withTablesToReload(TableToReload ... tablesToReload) {
        if (this.tablesToReload == null) {
            this.setTablesToReload(new ArrayList<TableToReload>(tablesToReload.length));
        }
        for (TableToReload ele : tablesToReload) {
            this.tablesToReload.add(ele);
        }
        return this;
    }

    public ReloadReplicationTablesRequest withTablesToReload(Collection<TableToReload> tablesToReload) {
        this.setTablesToReload(tablesToReload);
        return this;
    }

    public void setReloadOption(String reloadOption) {
        this.reloadOption = reloadOption;
    }

    public String getReloadOption() {
        return this.reloadOption;
    }

    public ReloadReplicationTablesRequest withReloadOption(String reloadOption) {
        this.setReloadOption(reloadOption);
        return this;
    }

    public ReloadReplicationTablesRequest withReloadOption(ReloadOptionValue reloadOption) {
        this.reloadOption = reloadOption.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationConfigArn() != null) {
            sb.append("ReplicationConfigArn: ").append(this.getReplicationConfigArn()).append(",");
        }
        if (this.getTablesToReload() != null) {
            sb.append("TablesToReload: ").append(this.getTablesToReload()).append(",");
        }
        if (this.getReloadOption() != null) {
            sb.append("ReloadOption: ").append(this.getReloadOption());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReloadReplicationTablesRequest)) {
            return false;
        }
        ReloadReplicationTablesRequest other = (ReloadReplicationTablesRequest)obj;
        if (other.getReplicationConfigArn() == null ^ this.getReplicationConfigArn() == null) {
            return false;
        }
        if (other.getReplicationConfigArn() != null && !other.getReplicationConfigArn().equals(this.getReplicationConfigArn())) {
            return false;
        }
        if (other.getTablesToReload() == null ^ this.getTablesToReload() == null) {
            return false;
        }
        if (other.getTablesToReload() != null && !other.getTablesToReload().equals(this.getTablesToReload())) {
            return false;
        }
        if (other.getReloadOption() == null ^ this.getReloadOption() == null) {
            return false;
        }
        return other.getReloadOption() == null || other.getReloadOption().equals(this.getReloadOption());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationConfigArn() == null ? 0 : this.getReplicationConfigArn().hashCode());
        hashCode = 31 * hashCode + (this.getTablesToReload() == null ? 0 : this.getTablesToReload().hashCode());
        hashCode = 31 * hashCode + (this.getReloadOption() == null ? 0 : this.getReloadOption().hashCode());
        return hashCode;
    }

    public ReloadReplicationTablesRequest clone() {
        return (ReloadReplicationTablesRequest)super.clone();
    }
}

