/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.databasemigrationservice.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * MongoDbDataProviderSettingsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class MongoDbDataProviderSettingsMarshaller {

    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Port").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> SSLMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SslMode").build();
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").build();
    private static final MarshallingInfo<String> AUTHTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AuthType").build();
    private static final MarshallingInfo<String> AUTHSOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthSource").build();
    private static final MarshallingInfo<String> AUTHMECHANISM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthMechanism").build();

    private static final MongoDbDataProviderSettingsMarshaller instance = new MongoDbDataProviderSettingsMarshaller();

    public static MongoDbDataProviderSettingsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MongoDbDataProviderSettings mongoDbDataProviderSettings, ProtocolMarshaller protocolMarshaller) {

        if (mongoDbDataProviderSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getServerName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getPort(), PORT_BINDING);
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getSslMode(), SSLMODE_BINDING);
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getCertificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getAuthType(), AUTHTYPE_BINDING);
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getAuthSource(), AUTHSOURCE_BINDING);
            protocolMarshaller.marshall(mongoDbDataProviderSettings.getAuthMechanism(), AUTHMECHANISM_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
