/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dlm.AmazonDLMAsync;
import com.amazonaws.services.dlm.AmazonDLMAsyncClientBuilder;
import com.amazonaws.services.dlm.AmazonDLMClient;
import com.amazonaws.services.dlm.model.CreateLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.CreateLifecyclePolicyResult;
import com.amazonaws.services.dlm.model.DeleteLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.DeleteLifecyclePolicyResult;
import com.amazonaws.services.dlm.model.GetLifecyclePoliciesRequest;
import com.amazonaws.services.dlm.model.GetLifecyclePoliciesResult;
import com.amazonaws.services.dlm.model.GetLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.GetLifecyclePolicyResult;
import com.amazonaws.services.dlm.model.UpdateLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.UpdateLifecyclePolicyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDLMAsyncClient
extends AmazonDLMClient
implements AmazonDLMAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonDLMAsyncClientBuilder asyncBuilder() {
        return AmazonDLMAsyncClientBuilder.standard();
    }

    AmazonDLMAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateLifecyclePolicyResult> createLifecyclePolicyAsync(CreateLifecyclePolicyRequest request) {
        return this.createLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<CreateLifecyclePolicyResult> createLifecyclePolicyAsync(CreateLifecyclePolicyRequest request, final AsyncHandler<CreateLifecyclePolicyRequest, CreateLifecyclePolicyResult> asyncHandler) {
        final CreateLifecyclePolicyRequest finalRequest = (CreateLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLifecyclePolicyResult>(){

            @Override
            public CreateLifecyclePolicyResult call() throws Exception {
                CreateLifecyclePolicyResult result = null;
                try {
                    result = AmazonDLMAsyncClient.this.executeCreateLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLifecyclePolicyResult> deleteLifecyclePolicyAsync(DeleteLifecyclePolicyRequest request) {
        return this.deleteLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<DeleteLifecyclePolicyResult> deleteLifecyclePolicyAsync(DeleteLifecyclePolicyRequest request, final AsyncHandler<DeleteLifecyclePolicyRequest, DeleteLifecyclePolicyResult> asyncHandler) {
        final DeleteLifecyclePolicyRequest finalRequest = (DeleteLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLifecyclePolicyResult>(){

            @Override
            public DeleteLifecyclePolicyResult call() throws Exception {
                DeleteLifecyclePolicyResult result = null;
                try {
                    result = AmazonDLMAsyncClient.this.executeDeleteLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLifecyclePoliciesResult> getLifecyclePoliciesAsync(GetLifecyclePoliciesRequest request) {
        return this.getLifecyclePoliciesAsync(request, null);
    }

    @Override
    public Future<GetLifecyclePoliciesResult> getLifecyclePoliciesAsync(GetLifecyclePoliciesRequest request, final AsyncHandler<GetLifecyclePoliciesRequest, GetLifecyclePoliciesResult> asyncHandler) {
        final GetLifecyclePoliciesRequest finalRequest = (GetLifecyclePoliciesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLifecyclePoliciesResult>(){

            @Override
            public GetLifecyclePoliciesResult call() throws Exception {
                GetLifecyclePoliciesResult result = null;
                try {
                    result = AmazonDLMAsyncClient.this.executeGetLifecyclePolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLifecyclePolicyResult> getLifecyclePolicyAsync(GetLifecyclePolicyRequest request) {
        return this.getLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<GetLifecyclePolicyResult> getLifecyclePolicyAsync(GetLifecyclePolicyRequest request, final AsyncHandler<GetLifecyclePolicyRequest, GetLifecyclePolicyResult> asyncHandler) {
        final GetLifecyclePolicyRequest finalRequest = (GetLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLifecyclePolicyResult>(){

            @Override
            public GetLifecyclePolicyResult call() throws Exception {
                GetLifecyclePolicyResult result = null;
                try {
                    result = AmazonDLMAsyncClient.this.executeGetLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLifecyclePolicyResult> updateLifecyclePolicyAsync(UpdateLifecyclePolicyRequest request) {
        return this.updateLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<UpdateLifecyclePolicyResult> updateLifecyclePolicyAsync(UpdateLifecyclePolicyRequest request, final AsyncHandler<UpdateLifecyclePolicyRequest, UpdateLifecyclePolicyResult> asyncHandler) {
        final UpdateLifecyclePolicyRequest finalRequest = (UpdateLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLifecyclePolicyResult>(){

            @Override
            public UpdateLifecyclePolicyResult call() throws Exception {
                UpdateLifecyclePolicyResult result = null;
                try {
                    result = AmazonDLMAsyncClient.this.executeUpdateLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

