/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryAsync;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryClient;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsResult;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsResult;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSApplicationDiscoveryAsyncClient
extends AWSApplicationDiscoveryClient
implements AWSApplicationDiscoveryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSApplicationDiscoveryAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AWSApplicationDiscoveryAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSApplicationDiscoveryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(final CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.createTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(final DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.deleteTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAgentsResult> describeAgentsAsync(DescribeAgentsRequest request) {
        return this.describeAgentsAsync(request, null);
    }

    @Override
    public Future<DescribeAgentsResult> describeAgentsAsync(final DescribeAgentsRequest request, final AsyncHandler<DescribeAgentsRequest, DescribeAgentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAgentsResult>(){

            @Override
            public DescribeAgentsResult call() throws Exception {
                DescribeAgentsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeAgents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationsResult> describeConfigurationsAsync(DescribeConfigurationsRequest request) {
        return this.describeConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationsResult> describeConfigurationsAsync(final DescribeConfigurationsRequest request, final AsyncHandler<DescribeConfigurationsRequest, DescribeConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConfigurationsResult>(){

            @Override
            public DescribeConfigurationsResult call() throws Exception {
                DescribeConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExportConfigurationsResult> describeExportConfigurationsAsync(DescribeExportConfigurationsRequest request) {
        return this.describeExportConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeExportConfigurationsResult> describeExportConfigurationsAsync(final DescribeExportConfigurationsRequest request, final AsyncHandler<DescribeExportConfigurationsRequest, DescribeExportConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeExportConfigurationsResult>(){

            @Override
            public DescribeExportConfigurationsResult call() throws Exception {
                DescribeExportConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeExportConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportConfigurationsResult> exportConfigurationsAsync(ExportConfigurationsRequest request) {
        return this.exportConfigurationsAsync(request, null);
    }

    @Override
    public Future<ExportConfigurationsResult> exportConfigurationsAsync(final ExportConfigurationsRequest request, final AsyncHandler<ExportConfigurationsRequest, ExportConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ExportConfigurationsResult>(){

            @Override
            public ExportConfigurationsResult call() throws Exception {
                ExportConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.exportConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request) {
        return this.listConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(final ListConfigurationsRequest request, final AsyncHandler<ListConfigurationsRequest, ListConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListConfigurationsResult>(){

            @Override
            public ListConfigurationsResult call() throws Exception {
                ListConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.listConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDataCollectionByAgentIdsResult> startDataCollectionByAgentIdsAsync(StartDataCollectionByAgentIdsRequest request) {
        return this.startDataCollectionByAgentIdsAsync(request, null);
    }

    @Override
    public Future<StartDataCollectionByAgentIdsResult> startDataCollectionByAgentIdsAsync(final StartDataCollectionByAgentIdsRequest request, final AsyncHandler<StartDataCollectionByAgentIdsRequest, StartDataCollectionByAgentIdsResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartDataCollectionByAgentIdsResult>(){

            @Override
            public StartDataCollectionByAgentIdsResult call() throws Exception {
                StartDataCollectionByAgentIdsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.startDataCollectionByAgentIds(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopDataCollectionByAgentIdsResult> stopDataCollectionByAgentIdsAsync(StopDataCollectionByAgentIdsRequest request) {
        return this.stopDataCollectionByAgentIdsAsync(request, null);
    }

    @Override
    public Future<StopDataCollectionByAgentIdsResult> stopDataCollectionByAgentIdsAsync(final StopDataCollectionByAgentIdsRequest request, final AsyncHandler<StopDataCollectionByAgentIdsRequest, StopDataCollectionByAgentIdsResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopDataCollectionByAgentIdsResult>(){

            @Override
            public StopDataCollectionByAgentIdsResult call() throws Exception {
                StopDataCollectionByAgentIdsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.stopDataCollectionByAgentIds(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

