/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.directconnect.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateConnectionRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The location of the connection.
     * </p>
     */
    private String location;
    /**
     * <p>
     * The bandwidth of the connection.
     * </p>
     */
    private String bandwidth;
    /**
     * <p>
     * The name of the connection.
     * </p>
     */
    private String connectionName;
    /**
     * <p>
     * The ID of the LAG.
     * </p>
     */
    private String lagId;
    /**
     * <p>
     * The tags to associate with the lag.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;
    /**
     * <p>
     * The name of the service provider associated with the requested connection.
     * </p>
     */
    private String providerName;
    /**
     * <p>
     * Indicates whether you want the connection to support MAC Security (MACsec).
     * </p>
     * <p>
     * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec)
     * prerequisties, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     * >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     */
    private Boolean requestMACSec;

    /**
     * <p>
     * The location of the connection.
     * </p>
     * 
     * @param location
     *        The location of the connection.
     */

    public void setLocation(String location) {
        this.location = location;
    }

    /**
     * <p>
     * The location of the connection.
     * </p>
     * 
     * @return The location of the connection.
     */

    public String getLocation() {
        return this.location;
    }

    /**
     * <p>
     * The location of the connection.
     * </p>
     * 
     * @param location
     *        The location of the connection.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withLocation(String location) {
        setLocation(location);
        return this;
    }

    /**
     * <p>
     * The bandwidth of the connection.
     * </p>
     * 
     * @param bandwidth
     *        The bandwidth of the connection.
     */

    public void setBandwidth(String bandwidth) {
        this.bandwidth = bandwidth;
    }

    /**
     * <p>
     * The bandwidth of the connection.
     * </p>
     * 
     * @return The bandwidth of the connection.
     */

    public String getBandwidth() {
        return this.bandwidth;
    }

    /**
     * <p>
     * The bandwidth of the connection.
     * </p>
     * 
     * @param bandwidth
     *        The bandwidth of the connection.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withBandwidth(String bandwidth) {
        setBandwidth(bandwidth);
        return this;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @param connectionName
     *        The name of the connection.
     */

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */

    public String getConnectionName() {
        return this.connectionName;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @param connectionName
     *        The name of the connection.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withConnectionName(String connectionName) {
        setConnectionName(connectionName);
        return this;
    }

    /**
     * <p>
     * The ID of the LAG.
     * </p>
     * 
     * @param lagId
     *        The ID of the LAG.
     */

    public void setLagId(String lagId) {
        this.lagId = lagId;
    }

    /**
     * <p>
     * The ID of the LAG.
     * </p>
     * 
     * @return The ID of the LAG.
     */

    public String getLagId() {
        return this.lagId;
    }

    /**
     * <p>
     * The ID of the LAG.
     * </p>
     * 
     * @param lagId
     *        The ID of the LAG.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withLagId(String lagId) {
        setLagId(lagId);
        return this;
    }

    /**
     * <p>
     * The tags to associate with the lag.
     * </p>
     * 
     * @return The tags to associate with the lag.
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * The tags to associate with the lag.
     * </p>
     * 
     * @param tags
     *        The tags to associate with the lag.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * The tags to associate with the lag.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The tags to associate with the lag.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags to associate with the lag.
     * </p>
     * 
     * @param tags
     *        The tags to associate with the lag.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * The name of the service provider associated with the requested connection.
     * </p>
     * 
     * @param providerName
     *        The name of the service provider associated with the requested connection.
     */

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    /**
     * <p>
     * The name of the service provider associated with the requested connection.
     * </p>
     * 
     * @return The name of the service provider associated with the requested connection.
     */

    public String getProviderName() {
        return this.providerName;
    }

    /**
     * <p>
     * The name of the service provider associated with the requested connection.
     * </p>
     * 
     * @param providerName
     *        The name of the service provider associated with the requested connection.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withProviderName(String providerName) {
        setProviderName(providerName);
        return this;
    }

    /**
     * <p>
     * Indicates whether you want the connection to support MAC Security (MACsec).
     * </p>
     * <p>
     * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec)
     * prerequisties, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     * >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * 
     * @param requestMACSec
     *        Indicates whether you want the connection to support MAC Security (MACsec).</p>
     *        <p>
     *        MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security
     *        (MACsec) prerequisties, see <a href=
     *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     *        >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     */

    public void setRequestMACSec(Boolean requestMACSec) {
        this.requestMACSec = requestMACSec;
    }

    /**
     * <p>
     * Indicates whether you want the connection to support MAC Security (MACsec).
     * </p>
     * <p>
     * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec)
     * prerequisties, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     * >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * 
     * @return Indicates whether you want the connection to support MAC Security (MACsec).</p>
     *         <p>
     *         MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security
     *         (MACsec) prerequisties, see <a href=
     *         "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     *         >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     */

    public Boolean getRequestMACSec() {
        return this.requestMACSec;
    }

    /**
     * <p>
     * Indicates whether you want the connection to support MAC Security (MACsec).
     * </p>
     * <p>
     * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec)
     * prerequisties, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     * >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * 
     * @param requestMACSec
     *        Indicates whether you want the connection to support MAC Security (MACsec).</p>
     *        <p>
     *        MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security
     *        (MACsec) prerequisties, see <a href=
     *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     *        >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateConnectionRequest withRequestMACSec(Boolean requestMACSec) {
        setRequestMACSec(requestMACSec);
        return this;
    }

    /**
     * <p>
     * Indicates whether you want the connection to support MAC Security (MACsec).
     * </p>
     * <p>
     * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec)
     * prerequisties, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     * >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * 
     * @return Indicates whether you want the connection to support MAC Security (MACsec).</p>
     *         <p>
     *         MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security
     *         (MACsec) prerequisties, see <a href=
     *         "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     *         >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     */

    public Boolean isRequestMACSec() {
        return this.requestMACSec;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLocation() != null)
            sb.append("Location: ").append(getLocation()).append(",");
        if (getBandwidth() != null)
            sb.append("Bandwidth: ").append(getBandwidth()).append(",");
        if (getConnectionName() != null)
            sb.append("ConnectionName: ").append(getConnectionName()).append(",");
        if (getLagId() != null)
            sb.append("LagId: ").append(getLagId()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getProviderName() != null)
            sb.append("ProviderName: ").append(getProviderName()).append(",");
        if (getRequestMACSec() != null)
            sb.append("RequestMACSec: ").append(getRequestMACSec());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateConnectionRequest == false)
            return false;
        CreateConnectionRequest other = (CreateConnectionRequest) obj;
        if (other.getLocation() == null ^ this.getLocation() == null)
            return false;
        if (other.getLocation() != null && other.getLocation().equals(this.getLocation()) == false)
            return false;
        if (other.getBandwidth() == null ^ this.getBandwidth() == null)
            return false;
        if (other.getBandwidth() != null && other.getBandwidth().equals(this.getBandwidth()) == false)
            return false;
        if (other.getConnectionName() == null ^ this.getConnectionName() == null)
            return false;
        if (other.getConnectionName() != null && other.getConnectionName().equals(this.getConnectionName()) == false)
            return false;
        if (other.getLagId() == null ^ this.getLagId() == null)
            return false;
        if (other.getLagId() != null && other.getLagId().equals(this.getLagId()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getProviderName() == null ^ this.getProviderName() == null)
            return false;
        if (other.getProviderName() != null && other.getProviderName().equals(this.getProviderName()) == false)
            return false;
        if (other.getRequestMACSec() == null ^ this.getRequestMACSec() == null)
            return false;
        if (other.getRequestMACSec() != null && other.getRequestMACSec().equals(this.getRequestMACSec()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLocation() == null) ? 0 : getLocation().hashCode());
        hashCode = prime * hashCode + ((getBandwidth() == null) ? 0 : getBandwidth().hashCode());
        hashCode = prime * hashCode + ((getConnectionName() == null) ? 0 : getConnectionName().hashCode());
        hashCode = prime * hashCode + ((getLagId() == null) ? 0 : getLagId().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getProviderName() == null) ? 0 : getProviderName().hashCode());
        hashCode = prime * hashCode + ((getRequestMACSec() == null) ? 0 : getRequestMACSec().hashCode());
        return hashCode;
    }

    @Override
    public CreateConnectionRequest clone() {
        return (CreateConnectionRequest) super.clone();
    }

}
