/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class StartBgpFailoverTestRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String virtualInterfaceId;
    private SdkInternalList<String> bgpPeers;
    private Integer testDurationInMinutes;

    public void setVirtualInterfaceId(String virtualInterfaceId) {
        this.virtualInterfaceId = virtualInterfaceId;
    }

    public String getVirtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public StartBgpFailoverTestRequest withVirtualInterfaceId(String virtualInterfaceId) {
        this.setVirtualInterfaceId(virtualInterfaceId);
        return this;
    }

    public List<String> getBgpPeers() {
        if (this.bgpPeers == null) {
            this.bgpPeers = new SdkInternalList();
        }
        return this.bgpPeers;
    }

    public void setBgpPeers(Collection<String> bgpPeers) {
        if (bgpPeers == null) {
            this.bgpPeers = null;
            return;
        }
        this.bgpPeers = new SdkInternalList(bgpPeers);
    }

    public StartBgpFailoverTestRequest withBgpPeers(String ... bgpPeers) {
        if (this.bgpPeers == null) {
            this.setBgpPeers((Collection<String>)new SdkInternalList(bgpPeers.length));
        }
        for (String ele : bgpPeers) {
            this.bgpPeers.add((Object)ele);
        }
        return this;
    }

    public StartBgpFailoverTestRequest withBgpPeers(Collection<String> bgpPeers) {
        this.setBgpPeers(bgpPeers);
        return this;
    }

    public void setTestDurationInMinutes(Integer testDurationInMinutes) {
        this.testDurationInMinutes = testDurationInMinutes;
    }

    public Integer getTestDurationInMinutes() {
        return this.testDurationInMinutes;
    }

    public StartBgpFailoverTestRequest withTestDurationInMinutes(Integer testDurationInMinutes) {
        this.setTestDurationInMinutes(testDurationInMinutes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVirtualInterfaceId() != null) {
            sb.append("VirtualInterfaceId: ").append(this.getVirtualInterfaceId()).append(",");
        }
        if (this.getBgpPeers() != null) {
            sb.append("BgpPeers: ").append(this.getBgpPeers()).append(",");
        }
        if (this.getTestDurationInMinutes() != null) {
            sb.append("TestDurationInMinutes: ").append(this.getTestDurationInMinutes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBgpFailoverTestRequest)) {
            return false;
        }
        StartBgpFailoverTestRequest other = (StartBgpFailoverTestRequest)obj;
        if (other.getVirtualInterfaceId() == null ^ this.getVirtualInterfaceId() == null) {
            return false;
        }
        if (other.getVirtualInterfaceId() != null && !other.getVirtualInterfaceId().equals(this.getVirtualInterfaceId())) {
            return false;
        }
        if (other.getBgpPeers() == null ^ this.getBgpPeers() == null) {
            return false;
        }
        if (other.getBgpPeers() != null && !other.getBgpPeers().equals(this.getBgpPeers())) {
            return false;
        }
        if (other.getTestDurationInMinutes() == null ^ this.getTestDurationInMinutes() == null) {
            return false;
        }
        return other.getTestDurationInMinutes() == null || other.getTestDurationInMinutes().equals(this.getTestDurationInMinutes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVirtualInterfaceId() == null ? 0 : this.getVirtualInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getBgpPeers() == null ? 0 : this.getBgpPeers().hashCode());
        hashCode = 31 * hashCode + (this.getTestDurationInMinutes() == null ? 0 : this.getTestDurationInMinutes().hashCode());
        return hashCode;
    }

    public StartBgpFailoverTestRequest clone() {
        return (StartBgpFailoverTestRequest)super.clone();
    }
}

