/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.CreateBGPPeerRequest;
import com.amazonaws.services.directconnect.model.transform.NewBGPPeerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateBGPPeerRequestMarshaller
implements Marshaller<Request<CreateBGPPeerRequest>, CreateBGPPeerRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateBGPPeerRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateBGPPeerRequest> marshall(CreateBGPPeerRequest createBGPPeerRequest) {
        if (createBGPPeerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createBGPPeerRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.CreateBGPPeer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createBGPPeerRequest.getVirtualInterfaceId() != null) {
                jsonGenerator.writeFieldName("virtualInterfaceId").writeValue(createBGPPeerRequest.getVirtualInterfaceId());
            }
            if (createBGPPeerRequest.getNewBGPPeer() != null) {
                jsonGenerator.writeFieldName("newBGPPeer");
                NewBGPPeerJsonMarshaller.getInstance().marshall(createBGPPeerRequest.getNewBGPPeer(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

