/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.NewPublicVirtualInterface;
import com.amazonaws.services.directconnect.model.RouteFilterPrefix;
import com.amazonaws.services.directconnect.model.transform.RouteFilterPrefixJsonMarshaller;

public class NewPublicVirtualInterfaceJsonMarshaller {
    private static NewPublicVirtualInterfaceJsonMarshaller instance;

    public void marshall(NewPublicVirtualInterface newPublicVirtualInterface, StructuredJsonGenerator jsonGenerator) {
        if (newPublicVirtualInterface == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList routeFilterPrefixesList;
            jsonGenerator.writeStartObject();
            if (newPublicVirtualInterface.getVirtualInterfaceName() != null) {
                jsonGenerator.writeFieldName("virtualInterfaceName").writeValue(newPublicVirtualInterface.getVirtualInterfaceName());
            }
            if (newPublicVirtualInterface.getVlan() != null) {
                jsonGenerator.writeFieldName("vlan").writeValue(newPublicVirtualInterface.getVlan().intValue());
            }
            if (newPublicVirtualInterface.getAsn() != null) {
                jsonGenerator.writeFieldName("asn").writeValue(newPublicVirtualInterface.getAsn().intValue());
            }
            if (newPublicVirtualInterface.getAuthKey() != null) {
                jsonGenerator.writeFieldName("authKey").writeValue(newPublicVirtualInterface.getAuthKey());
            }
            if (newPublicVirtualInterface.getAmazonAddress() != null) {
                jsonGenerator.writeFieldName("amazonAddress").writeValue(newPublicVirtualInterface.getAmazonAddress());
            }
            if (newPublicVirtualInterface.getCustomerAddress() != null) {
                jsonGenerator.writeFieldName("customerAddress").writeValue(newPublicVirtualInterface.getCustomerAddress());
            }
            if (!(routeFilterPrefixesList = (SdkInternalList)newPublicVirtualInterface.getRouteFilterPrefixes()).isEmpty() || !routeFilterPrefixesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("routeFilterPrefixes");
                jsonGenerator.writeStartArray();
                for (RouteFilterPrefix routeFilterPrefixesListValue : routeFilterPrefixesList) {
                    if (routeFilterPrefixesListValue == null) continue;
                    RouteFilterPrefixJsonMarshaller.getInstance().marshall(routeFilterPrefixesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NewPublicVirtualInterfaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NewPublicVirtualInterfaceJsonMarshaller();
        }
        return instance;
    }
}

