/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devopsguru.model.ResourcePermission;
import com.amazonaws.services.devopsguru.model.ResourceTypeFilter;
import com.amazonaws.services.devopsguru.model.transform.ListMonitoredResourcesFiltersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMonitoredResourcesFilters
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourcePermission;
    private List<String> resourceTypeFilters;

    public void setResourcePermission(String resourcePermission) {
        this.resourcePermission = resourcePermission;
    }

    public String getResourcePermission() {
        return this.resourcePermission;
    }

    public ListMonitoredResourcesFilters withResourcePermission(String resourcePermission) {
        this.setResourcePermission(resourcePermission);
        return this;
    }

    public ListMonitoredResourcesFilters withResourcePermission(ResourcePermission resourcePermission) {
        this.resourcePermission = resourcePermission.toString();
        return this;
    }

    public List<String> getResourceTypeFilters() {
        return this.resourceTypeFilters;
    }

    public void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
        if (resourceTypeFilters == null) {
            this.resourceTypeFilters = null;
            return;
        }
        this.resourceTypeFilters = new ArrayList<String>(resourceTypeFilters);
    }

    public ListMonitoredResourcesFilters withResourceTypeFilters(String ... resourceTypeFilters) {
        if (this.resourceTypeFilters == null) {
            this.setResourceTypeFilters(new ArrayList<String>(resourceTypeFilters.length));
        }
        for (String ele : resourceTypeFilters) {
            this.resourceTypeFilters.add(ele);
        }
        return this;
    }

    public ListMonitoredResourcesFilters withResourceTypeFilters(Collection<String> resourceTypeFilters) {
        this.setResourceTypeFilters(resourceTypeFilters);
        return this;
    }

    public ListMonitoredResourcesFilters withResourceTypeFilters(ResourceTypeFilter ... resourceTypeFilters) {
        ArrayList<String> resourceTypeFiltersCopy = new ArrayList<String>(resourceTypeFilters.length);
        for (ResourceTypeFilter value : resourceTypeFilters) {
            resourceTypeFiltersCopy.add(value.toString());
        }
        if (this.getResourceTypeFilters() == null) {
            this.setResourceTypeFilters(resourceTypeFiltersCopy);
        } else {
            this.getResourceTypeFilters().addAll(resourceTypeFiltersCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourcePermission() != null) {
            sb.append("ResourcePermission: ").append(this.getResourcePermission()).append(",");
        }
        if (this.getResourceTypeFilters() != null) {
            sb.append("ResourceTypeFilters: ").append(this.getResourceTypeFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoredResourcesFilters)) {
            return false;
        }
        ListMonitoredResourcesFilters other = (ListMonitoredResourcesFilters)obj;
        if (other.getResourcePermission() == null ^ this.getResourcePermission() == null) {
            return false;
        }
        if (other.getResourcePermission() != null && !other.getResourcePermission().equals(this.getResourcePermission())) {
            return false;
        }
        if (other.getResourceTypeFilters() == null ^ this.getResourceTypeFilters() == null) {
            return false;
        }
        return other.getResourceTypeFilters() == null || other.getResourceTypeFilters().equals(this.getResourceTypeFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourcePermission() == null ? 0 : this.getResourcePermission().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypeFilters() == null ? 0 : this.getResourceTypeFilters().hashCode());
        return hashCode;
    }

    public ListMonitoredResourcesFilters clone() {
        try {
            return (ListMonitoredResourcesFilters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ListMonitoredResourcesFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

