/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devopsguru.model.CloudFormationCollectionFilter;
import com.amazonaws.services.devopsguru.model.TagCollectionFilter;
import com.amazonaws.services.devopsguru.model.transform.ResourceCollectionFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceCollectionFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private CloudFormationCollectionFilter cloudFormation;
    private List<TagCollectionFilter> tags;

    public void setCloudFormation(CloudFormationCollectionFilter cloudFormation) {
        this.cloudFormation = cloudFormation;
    }

    public CloudFormationCollectionFilter getCloudFormation() {
        return this.cloudFormation;
    }

    public ResourceCollectionFilter withCloudFormation(CloudFormationCollectionFilter cloudFormation) {
        this.setCloudFormation(cloudFormation);
        return this;
    }

    public List<TagCollectionFilter> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagCollectionFilter> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagCollectionFilter>(tags);
    }

    public ResourceCollectionFilter withTags(TagCollectionFilter ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagCollectionFilter>(tags.length));
        }
        for (TagCollectionFilter ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ResourceCollectionFilter withTags(Collection<TagCollectionFilter> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCloudFormation() != null) {
            sb.append("CloudFormation: ").append(this.getCloudFormation()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCollectionFilter)) {
            return false;
        }
        ResourceCollectionFilter other = (ResourceCollectionFilter)obj;
        if (other.getCloudFormation() == null ^ this.getCloudFormation() == null) {
            return false;
        }
        if (other.getCloudFormation() != null && !other.getCloudFormation().equals(this.getCloudFormation())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCloudFormation() == null ? 0 : this.getCloudFormation().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ResourceCollectionFilter clone() {
        try {
            return (ResourceCollectionFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceCollectionFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

