/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.devicefarm.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteTestGridProject" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteTestGridProjectRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     * </p>
     */
    private String projectArn;

    /**
     * <p>
     * The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     * </p>
     * 
     * @param projectArn
     *        The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     */

    public void setProjectArn(String projectArn) {
        this.projectArn = projectArn;
    }

    /**
     * <p>
     * The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     * </p>
     * 
     * @return The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     */

    public String getProjectArn() {
        return this.projectArn;
    }

    /**
     * <p>
     * The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     * </p>
     * 
     * @param projectArn
     *        The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteTestGridProjectRequest withProjectArn(String projectArn) {
        setProjectArn(projectArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getProjectArn() != null)
            sb.append("ProjectArn: ").append(getProjectArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteTestGridProjectRequest == false)
            return false;
        DeleteTestGridProjectRequest other = (DeleteTestGridProjectRequest) obj;
        if (other.getProjectArn() == null ^ this.getProjectArn() == null)
            return false;
        if (other.getProjectArn() != null && other.getProjectArn().equals(this.getProjectArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getProjectArn() == null) ? 0 : getProjectArn().hashCode());
        return hashCode;
    }

    @Override
    public DeleteTestGridProjectRequest clone() {
        return (DeleteTestGridProjectRequest) super.clone();
    }

}
