/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.OfferingStatus;
import com.amazonaws.services.devicefarm.model.transform.OfferingJsonMarshaller;

public class OfferingStatusJsonMarshaller {
    private static OfferingStatusJsonMarshaller instance;

    public void marshall(OfferingStatus offeringStatus, StructuredJsonGenerator jsonGenerator) {
        if (offeringStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (offeringStatus.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(offeringStatus.getType());
            }
            if (offeringStatus.getOffering() != null) {
                jsonGenerator.writeFieldName("offering");
                OfferingJsonMarshaller.getInstance().marshall(offeringStatus.getOffering(), jsonGenerator);
            }
            if (offeringStatus.getQuantity() != null) {
                jsonGenerator.writeFieldName("quantity").writeValue(offeringStatus.getQuantity().intValue());
            }
            if (offeringStatus.getEffectiveOn() != null) {
                jsonGenerator.writeFieldName("effectiveOn").writeValue(offeringStatus.getEffectiveOn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OfferingStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OfferingStatusJsonMarshaller();
        }
        return instance;
    }
}

