/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.PurchaseOfferingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PurchaseOfferingRequestMarshaller
implements Marshaller<Request<PurchaseOfferingRequest>, PurchaseOfferingRequest> {
    public Request<PurchaseOfferingRequest> marshall(PurchaseOfferingRequest purchaseOfferingRequest) {
        if (purchaseOfferingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseOfferingRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.PurchaseOffering");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (purchaseOfferingRequest.getOfferingId() != null) {
                jsonGenerator.writeFieldName("offeringId").writeValue(purchaseOfferingRequest.getOfferingId());
            }
            if (purchaseOfferingRequest.getQuantity() != null) {
                jsonGenerator.writeFieldName("quantity").writeValue((long)purchaseOfferingRequest.getQuantity().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

