/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.ScheduleRunConfiguration;
import com.amazonaws.services.devicefarm.model.transform.LocationJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.RadiosJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ScheduleRunConfigurationJsonMarshaller {
    private static ScheduleRunConfigurationJsonMarshaller instance;

    public void marshall(ScheduleRunConfiguration scheduleRunConfiguration, JSONWriter jsonWriter) {
        if (scheduleRunConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> auxiliaryAppsList;
            jsonWriter.object();
            if (scheduleRunConfiguration.getExtraDataPackageArn() != null) {
                jsonWriter.key("extraDataPackageArn").value((Object)scheduleRunConfiguration.getExtraDataPackageArn());
            }
            if (scheduleRunConfiguration.getNetworkProfileArn() != null) {
                jsonWriter.key("networkProfileArn").value((Object)scheduleRunConfiguration.getNetworkProfileArn());
            }
            if (scheduleRunConfiguration.getLocale() != null) {
                jsonWriter.key("locale").value((Object)scheduleRunConfiguration.getLocale());
            }
            if (scheduleRunConfiguration.getLocation() != null) {
                jsonWriter.key("location");
                LocationJsonMarshaller.getInstance().marshall(scheduleRunConfiguration.getLocation(), jsonWriter);
            }
            if (scheduleRunConfiguration.getRadios() != null) {
                jsonWriter.key("radios");
                RadiosJsonMarshaller.getInstance().marshall(scheduleRunConfiguration.getRadios(), jsonWriter);
            }
            if ((auxiliaryAppsList = scheduleRunConfiguration.getAuxiliaryApps()) != null) {
                jsonWriter.key("auxiliaryApps");
                jsonWriter.array();
                for (String auxiliaryAppsListValue : auxiliaryAppsList) {
                    if (auxiliaryAppsListValue == null) continue;
                    jsonWriter.value((Object)auxiliaryAppsListValue);
                }
                jsonWriter.endArray();
            }
            if (scheduleRunConfiguration.getBillingMethod() != null) {
                jsonWriter.key("billingMethod").value((Object)scheduleRunConfiguration.getBillingMethod());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScheduleRunConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScheduleRunConfigurationJsonMarshaller();
        }
        return instance;
    }
}

