/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.detective.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.detective.model.DatasourcePackage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateDatasourcePackagesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String graphArn;
    private List<String> datasourcePackages;

    public void setGraphArn(String graphArn) {
        this.graphArn = graphArn;
    }

    public String getGraphArn() {
        return this.graphArn;
    }

    public UpdateDatasourcePackagesRequest withGraphArn(String graphArn) {
        this.setGraphArn(graphArn);
        return this;
    }

    public List<String> getDatasourcePackages() {
        return this.datasourcePackages;
    }

    public void setDatasourcePackages(Collection<String> datasourcePackages) {
        if (datasourcePackages == null) {
            this.datasourcePackages = null;
            return;
        }
        this.datasourcePackages = new ArrayList<String>(datasourcePackages);
    }

    public UpdateDatasourcePackagesRequest withDatasourcePackages(String ... datasourcePackages) {
        if (this.datasourcePackages == null) {
            this.setDatasourcePackages(new ArrayList<String>(datasourcePackages.length));
        }
        for (String ele : datasourcePackages) {
            this.datasourcePackages.add(ele);
        }
        return this;
    }

    public UpdateDatasourcePackagesRequest withDatasourcePackages(Collection<String> datasourcePackages) {
        this.setDatasourcePackages(datasourcePackages);
        return this;
    }

    public UpdateDatasourcePackagesRequest withDatasourcePackages(DatasourcePackage ... datasourcePackages) {
        ArrayList<String> datasourcePackagesCopy = new ArrayList<String>(datasourcePackages.length);
        for (DatasourcePackage value : datasourcePackages) {
            datasourcePackagesCopy.add(value.toString());
        }
        if (this.getDatasourcePackages() == null) {
            this.setDatasourcePackages(datasourcePackagesCopy);
        } else {
            this.getDatasourcePackages().addAll(datasourcePackagesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGraphArn() != null) {
            sb.append("GraphArn: ").append(this.getGraphArn()).append(",");
        }
        if (this.getDatasourcePackages() != null) {
            sb.append("DatasourcePackages: ").append(this.getDatasourcePackages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasourcePackagesRequest)) {
            return false;
        }
        UpdateDatasourcePackagesRequest other = (UpdateDatasourcePackagesRequest)obj;
        if (other.getGraphArn() == null ^ this.getGraphArn() == null) {
            return false;
        }
        if (other.getGraphArn() != null && !other.getGraphArn().equals(this.getGraphArn())) {
            return false;
        }
        if (other.getDatasourcePackages() == null ^ this.getDatasourcePackages() == null) {
            return false;
        }
        return other.getDatasourcePackages() == null || other.getDatasourcePackages().equals(this.getDatasourcePackages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGraphArn() == null ? 0 : this.getGraphArn().hashCode());
        hashCode = 31 * hashCode + (this.getDatasourcePackages() == null ? 0 : this.getDatasourcePackages().hashCode());
        return hashCode;
    }

    public UpdateDatasourcePackagesRequest clone() {
        return (UpdateDatasourcePackagesRequest)super.clone();
    }
}

