/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.detective.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.detective.model.MemberDetail;
import com.amazonaws.services.detective.model.UnprocessedAccount;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMembersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<MemberDetail> members;
    private List<UnprocessedAccount> unprocessedAccounts;

    public List<MemberDetail> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<MemberDetail> members) {
        if (members == null) {
            this.members = null;
            return;
        }
        this.members = new ArrayList<MemberDetail>(members);
    }

    public CreateMembersResult withMembers(MemberDetail ... members) {
        if (this.members == null) {
            this.setMembers(new ArrayList<MemberDetail>(members.length));
        }
        for (MemberDetail ele : members) {
            this.members.add(ele);
        }
        return this;
    }

    public CreateMembersResult withMembers(Collection<MemberDetail> members) {
        this.setMembers(members);
        return this;
    }

    public List<UnprocessedAccount> getUnprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public void setUnprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
        if (unprocessedAccounts == null) {
            this.unprocessedAccounts = null;
            return;
        }
        this.unprocessedAccounts = new ArrayList<UnprocessedAccount>(unprocessedAccounts);
    }

    public CreateMembersResult withUnprocessedAccounts(UnprocessedAccount ... unprocessedAccounts) {
        if (this.unprocessedAccounts == null) {
            this.setUnprocessedAccounts(new ArrayList<UnprocessedAccount>(unprocessedAccounts.length));
        }
        for (UnprocessedAccount ele : unprocessedAccounts) {
            this.unprocessedAccounts.add(ele);
        }
        return this;
    }

    public CreateMembersResult withUnprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
        this.setUnprocessedAccounts(unprocessedAccounts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMembers() != null) {
            sb.append("Members: ").append(this.getMembers()).append(",");
        }
        if (this.getUnprocessedAccounts() != null) {
            sb.append("UnprocessedAccounts: ").append(this.getUnprocessedAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersResult)) {
            return false;
        }
        CreateMembersResult other = (CreateMembersResult)obj;
        if (other.getMembers() == null ^ this.getMembers() == null) {
            return false;
        }
        if (other.getMembers() != null && !other.getMembers().equals(this.getMembers())) {
            return false;
        }
        if (other.getUnprocessedAccounts() == null ^ this.getUnprocessedAccounts() == null) {
            return false;
        }
        return other.getUnprocessedAccounts() == null || other.getUnprocessedAccounts().equals(this.getUnprocessedAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMembers() == null ? 0 : this.getMembers().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedAccounts() == null ? 0 : this.getUnprocessedAccounts().hashCode());
        return hashCode;
    }

    public CreateMembersResult clone() {
        try {
            return (CreateMembersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

