/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.deadline;

import javax.annotation.Generated;

import com.amazonaws.services.deadline.model.*;
import com.amazonaws.*;
import com.amazonaws.services.deadline.waiters.AWSDeadlineWaiters;

/**
 * Abstract implementation of {@code AWSDeadline}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSDeadline implements AWSDeadline {

    protected AbstractAWSDeadline() {
    }

    @Override
    public AssociateMemberToFarmResult associateMemberToFarm(AssociateMemberToFarmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateMemberToFleetResult associateMemberToFleet(AssociateMemberToFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateMemberToJobResult associateMemberToJob(AssociateMemberToJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateMemberToQueueResult associateMemberToQueue(AssociateMemberToQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssumeFleetRoleForReadResult assumeFleetRoleForRead(AssumeFleetRoleForReadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssumeFleetRoleForWorkerResult assumeFleetRoleForWorker(AssumeFleetRoleForWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssumeQueueRoleForReadResult assumeQueueRoleForRead(AssumeQueueRoleForReadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssumeQueueRoleForUserResult assumeQueueRoleForUser(AssumeQueueRoleForUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssumeQueueRoleForWorkerResult assumeQueueRoleForWorker(AssumeQueueRoleForWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetJobEntityResult batchGetJobEntity(BatchGetJobEntityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CopyJobTemplateResult copyJobTemplate(CopyJobTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBudgetResult createBudget(CreateBudgetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFarmResult createFarm(CreateFarmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFleetResult createFleet(CreateFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLicenseEndpointResult createLicenseEndpoint(CreateLicenseEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMonitorResult createMonitor(CreateMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateQueueResult createQueue(CreateQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateQueueEnvironmentResult createQueueEnvironment(CreateQueueEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateQueueFleetAssociationResult createQueueFleetAssociation(CreateQueueFleetAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStorageProfileResult createStorageProfile(CreateStorageProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkerResult createWorker(CreateWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBudgetResult deleteBudget(DeleteBudgetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFarmResult deleteFarm(DeleteFarmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFleetResult deleteFleet(DeleteFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLicenseEndpointResult deleteLicenseEndpoint(DeleteLicenseEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMeteredProductResult deleteMeteredProduct(DeleteMeteredProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMonitorResult deleteMonitor(DeleteMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQueueResult deleteQueue(DeleteQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQueueEnvironmentResult deleteQueueEnvironment(DeleteQueueEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQueueFleetAssociationResult deleteQueueFleetAssociation(DeleteQueueFleetAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteStorageProfileResult deleteStorageProfile(DeleteStorageProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkerResult deleteWorker(DeleteWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMemberFromFarmResult disassociateMemberFromFarm(DisassociateMemberFromFarmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMemberFromFleetResult disassociateMemberFromFleet(DisassociateMemberFromFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMemberFromJobResult disassociateMemberFromJob(DisassociateMemberFromJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMemberFromQueueResult disassociateMemberFromQueue(DisassociateMemberFromQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBudgetResult getBudget(GetBudgetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFarmResult getFarm(GetFarmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFleetResult getFleet(GetFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLicenseEndpointResult getLicenseEndpoint(GetLicenseEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMonitorResult getMonitor(GetMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQueueResult getQueue(GetQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQueueEnvironmentResult getQueueEnvironment(GetQueueEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQueueFleetAssociationResult getQueueFleetAssociation(GetQueueFleetAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSessionResult getSession(GetSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSessionActionResult getSessionAction(GetSessionActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSessionsStatisticsAggregationResult getSessionsStatisticsAggregation(GetSessionsStatisticsAggregationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStepResult getStep(GetStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStorageProfileResult getStorageProfile(GetStorageProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStorageProfileForQueueResult getStorageProfileForQueue(GetStorageProfileForQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTaskResult getTask(GetTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkerResult getWorker(GetWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAvailableMeteredProductsResult listAvailableMeteredProducts(ListAvailableMeteredProductsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBudgetsResult listBudgets(ListBudgetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFarmMembersResult listFarmMembers(ListFarmMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFarmsResult listFarms(ListFarmsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFleetMembersResult listFleetMembers(ListFleetMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFleetsResult listFleets(ListFleetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobMembersResult listJobMembers(ListJobMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLicenseEndpointsResult listLicenseEndpoints(ListLicenseEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMeteredProductsResult listMeteredProducts(ListMeteredProductsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitorsResult listMonitors(ListMonitorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQueueEnvironmentsResult listQueueEnvironments(ListQueueEnvironmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQueueFleetAssociationsResult listQueueFleetAssociations(ListQueueFleetAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQueueMembersResult listQueueMembers(ListQueueMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSessionActionsResult listSessionActions(ListSessionActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSessionsResult listSessions(ListSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSessionsForWorkerResult listSessionsForWorker(ListSessionsForWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStepConsumersResult listStepConsumers(ListStepConsumersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStepDependenciesResult listStepDependencies(ListStepDependenciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStepsResult listSteps(ListStepsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStorageProfilesResult listStorageProfiles(ListStorageProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStorageProfilesForQueueResult listStorageProfilesForQueue(ListStorageProfilesForQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTasksResult listTasks(ListTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkersResult listWorkers(ListWorkersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutMeteredProductResult putMeteredProduct(PutMeteredProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchJobsResult searchJobs(SearchJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchStepsResult searchSteps(SearchStepsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchTasksResult searchTasks(SearchTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchWorkersResult searchWorkers(SearchWorkersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSessionsStatisticsAggregationResult startSessionsStatisticsAggregation(StartSessionsStatisticsAggregationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBudgetResult updateBudget(UpdateBudgetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFarmResult updateFarm(UpdateFarmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFleetResult updateFleet(UpdateFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateJobResult updateJob(UpdateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMonitorResult updateMonitor(UpdateMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQueueResult updateQueue(UpdateQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQueueEnvironmentResult updateQueueEnvironment(UpdateQueueEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQueueFleetAssociationResult updateQueueFleetAssociation(UpdateQueueFleetAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSessionResult updateSession(UpdateSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStepResult updateStep(UpdateStepRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStorageProfileResult updateStorageProfile(UpdateStorageProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTaskResult updateTask(UpdateTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkerResult updateWorker(UpdateWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkerScheduleResult updateWorkerSchedule(UpdateWorkerScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AWSDeadlineWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
