/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.JobSearchSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchJobsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<JobSearchSummary> jobs;
    private Integer nextItemOffset;
    private Integer totalResults;

    public List<JobSearchSummary> getJobs() {
        return this.jobs;
    }

    public void setJobs(Collection<JobSearchSummary> jobs) {
        if (jobs == null) {
            this.jobs = null;
            return;
        }
        this.jobs = new ArrayList<JobSearchSummary>(jobs);
    }

    public SearchJobsResult withJobs(JobSearchSummary ... jobs) {
        if (this.jobs == null) {
            this.setJobs(new ArrayList<JobSearchSummary>(jobs.length));
        }
        for (JobSearchSummary ele : jobs) {
            this.jobs.add(ele);
        }
        return this;
    }

    public SearchJobsResult withJobs(Collection<JobSearchSummary> jobs) {
        this.setJobs(jobs);
        return this;
    }

    public void setNextItemOffset(Integer nextItemOffset) {
        this.nextItemOffset = nextItemOffset;
    }

    public Integer getNextItemOffset() {
        return this.nextItemOffset;
    }

    public SearchJobsResult withNextItemOffset(Integer nextItemOffset) {
        this.setNextItemOffset(nextItemOffset);
        return this;
    }

    public void setTotalResults(Integer totalResults) {
        this.totalResults = totalResults;
    }

    public Integer getTotalResults() {
        return this.totalResults;
    }

    public SearchJobsResult withTotalResults(Integer totalResults) {
        this.setTotalResults(totalResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobs() != null) {
            sb.append("Jobs: ").append(this.getJobs()).append(",");
        }
        if (this.getNextItemOffset() != null) {
            sb.append("NextItemOffset: ").append(this.getNextItemOffset()).append(",");
        }
        if (this.getTotalResults() != null) {
            sb.append("TotalResults: ").append(this.getTotalResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobsResult)) {
            return false;
        }
        SearchJobsResult other = (SearchJobsResult)obj;
        if (other.getJobs() == null ^ this.getJobs() == null) {
            return false;
        }
        if (other.getJobs() != null && !other.getJobs().equals(this.getJobs())) {
            return false;
        }
        if (other.getNextItemOffset() == null ^ this.getNextItemOffset() == null) {
            return false;
        }
        if (other.getNextItemOffset() != null && !other.getNextItemOffset().equals(this.getNextItemOffset())) {
            return false;
        }
        if (other.getTotalResults() == null ^ this.getTotalResults() == null) {
            return false;
        }
        return other.getTotalResults() == null || other.getTotalResults().equals(this.getTotalResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobs() == null ? 0 : this.getJobs().hashCode());
        hashCode = 31 * hashCode + (this.getNextItemOffset() == null ? 0 : this.getNextItemOffset().hashCode());
        hashCode = 31 * hashCode + (this.getTotalResults() == null ? 0 : this.getTotalResults().hashCode());
        return hashCode;
    }

    public SearchJobsResult clone() {
        try {
            return (SearchJobsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

