/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.JobAttachmentsFileSystem;
import com.amazonaws.services.deadline.model.ManifestProperties;
import com.amazonaws.services.deadline.model.transform.AttachmentsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Attachments
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileSystem;
    private List<ManifestProperties> manifests;

    public void setFileSystem(String fileSystem) {
        this.fileSystem = fileSystem;
    }

    public String getFileSystem() {
        return this.fileSystem;
    }

    public Attachments withFileSystem(String fileSystem) {
        this.setFileSystem(fileSystem);
        return this;
    }

    public Attachments withFileSystem(JobAttachmentsFileSystem fileSystem) {
        this.fileSystem = fileSystem.toString();
        return this;
    }

    public List<ManifestProperties> getManifests() {
        return this.manifests;
    }

    public void setManifests(Collection<ManifestProperties> manifests) {
        if (manifests == null) {
            this.manifests = null;
            return;
        }
        this.manifests = new ArrayList<ManifestProperties>(manifests);
    }

    public Attachments withManifests(ManifestProperties ... manifests) {
        if (this.manifests == null) {
            this.setManifests(new ArrayList<ManifestProperties>(manifests.length));
        }
        for (ManifestProperties ele : manifests) {
            this.manifests.add(ele);
        }
        return this;
    }

    public Attachments withManifests(Collection<ManifestProperties> manifests) {
        this.setManifests(manifests);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileSystem() != null) {
            sb.append("FileSystem: ").append(this.getFileSystem()).append(",");
        }
        if (this.getManifests() != null) {
            sb.append("Manifests: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachments)) {
            return false;
        }
        Attachments other = (Attachments)obj;
        if (other.getFileSystem() == null ^ this.getFileSystem() == null) {
            return false;
        }
        if (other.getFileSystem() != null && !other.getFileSystem().equals(this.getFileSystem())) {
            return false;
        }
        if (other.getManifests() == null ^ this.getManifests() == null) {
            return false;
        }
        return other.getManifests() == null || other.getManifests().equals(this.getManifests());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileSystem() == null ? 0 : this.getFileSystem().hashCode());
        hashCode = 31 * hashCode + (this.getManifests() == null ? 0 : this.getManifests().hashCode());
        return hashCode;
    }

    public Attachments clone() {
        try {
            return (Attachments)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

