/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.services.deadline.model.AWSDeadlineException;
import com.amazonaws.services.deadline.model.ConflictExceptionReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class ConflictException
extends AWSDeadlineException {
    private static final long serialVersionUID = 1L;
    private Map<String, String> context;
    private String reason;
    private String resourceId;
    private String resourceType;

    public ConflictException(String message) {
        super(message);
    }

    @JsonProperty(value="context")
    public Map<String, String> getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public ConflictException withContext(Map<String, String> context) {
        this.setContext(context);
        return this;
    }

    public ConflictException addContextEntry(String key, String value) {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        if (this.context.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.context.put(key, value);
        return this;
    }

    public ConflictException clearContextEntries() {
        this.context = null;
        return this;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    public ConflictException withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public ConflictException withReason(ConflictExceptionReason reason) {
        this.reason = reason.toString();
        return this;
    }

    @JsonProperty(value="resourceId")
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @JsonProperty(value="resourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    public ConflictException withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    @JsonProperty(value="resourceType")
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @JsonProperty(value="resourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    public ConflictException withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }
}

