/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.QueueSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListQueuesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<QueueSummary> queues;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListQueuesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<QueueSummary> getQueues() {
        return this.queues;
    }

    public void setQueues(Collection<QueueSummary> queues) {
        if (queues == null) {
            this.queues = null;
            return;
        }
        this.queues = new ArrayList<QueueSummary>(queues);
    }

    public ListQueuesResult withQueues(QueueSummary ... queues) {
        if (this.queues == null) {
            this.setQueues(new ArrayList<QueueSummary>(queues.length));
        }
        for (QueueSummary ele : queues) {
            this.queues.add(ele);
        }
        return this;
    }

    public ListQueuesResult withQueues(Collection<QueueSummary> queues) {
        this.setQueues(queues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getQueues() != null) {
            sb.append("Queues: ").append(this.getQueues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResult)) {
            return false;
        }
        ListQueuesResult other = (ListQueuesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getQueues() == null ^ this.getQueues() == null) {
            return false;
        }
        return other.getQueues() == null || other.getQueues().equals(this.getQueues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getQueues() == null ? 0 : this.getQueues().hashCode());
        return hashCode;
    }

    public ListQueuesResult clone() {
        try {
            return (ListQueuesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

