/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datazone.model.Import;

@SdkInternalApi
public class ImportMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").build();
    private static final ImportMarshaller instance = new ImportMarshaller();

    public static ImportMarshaller getInstance() {
        return instance;
    }

    public void marshall(Import importValue, ProtocolMarshaller protocolMarshaller) {
        if (importValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importValue.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)importValue.getRevision(), REVISION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

