/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datazone.model.NotificationType;
import com.amazonaws.services.datazone.model.TaskStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListNotificationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Date afterTimestamp;
    private Date beforeTimestamp;
    private String domainIdentifier;
    private Integer maxResults;
    private String nextToken;
    private List<String> subjects;
    private String taskStatus;
    private String type;

    public void setAfterTimestamp(Date afterTimestamp) {
        this.afterTimestamp = afterTimestamp;
    }

    public Date getAfterTimestamp() {
        return this.afterTimestamp;
    }

    public ListNotificationsRequest withAfterTimestamp(Date afterTimestamp) {
        this.setAfterTimestamp(afterTimestamp);
        return this;
    }

    public void setBeforeTimestamp(Date beforeTimestamp) {
        this.beforeTimestamp = beforeTimestamp;
    }

    public Date getBeforeTimestamp() {
        return this.beforeTimestamp;
    }

    public ListNotificationsRequest withBeforeTimestamp(Date beforeTimestamp) {
        this.setBeforeTimestamp(beforeTimestamp);
        return this;
    }

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public ListNotificationsRequest withDomainIdentifier(String domainIdentifier) {
        this.setDomainIdentifier(domainIdentifier);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListNotificationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListNotificationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(Collection<String> subjects) {
        if (subjects == null) {
            this.subjects = null;
            return;
        }
        this.subjects = new ArrayList<String>(subjects);
    }

    public ListNotificationsRequest withSubjects(String ... subjects) {
        if (this.subjects == null) {
            this.setSubjects(new ArrayList<String>(subjects.length));
        }
        for (String ele : subjects) {
            this.subjects.add(ele);
        }
        return this;
    }

    public ListNotificationsRequest withSubjects(Collection<String> subjects) {
        this.setSubjects(subjects);
        return this;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public ListNotificationsRequest withTaskStatus(String taskStatus) {
        this.setTaskStatus(taskStatus);
        return this;
    }

    public ListNotificationsRequest withTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ListNotificationsRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public ListNotificationsRequest withType(NotificationType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAfterTimestamp() != null) {
            sb.append("AfterTimestamp: ").append(this.getAfterTimestamp()).append(",");
        }
        if (this.getBeforeTimestamp() != null) {
            sb.append("BeforeTimestamp: ").append(this.getBeforeTimestamp()).append(",");
        }
        if (this.getDomainIdentifier() != null) {
            sb.append("DomainIdentifier: ").append(this.getDomainIdentifier()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSubjects() != null) {
            sb.append("Subjects: ").append(this.getSubjects()).append(",");
        }
        if (this.getTaskStatus() != null) {
            sb.append("TaskStatus: ").append(this.getTaskStatus()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsRequest)) {
            return false;
        }
        ListNotificationsRequest other = (ListNotificationsRequest)obj;
        if (other.getAfterTimestamp() == null ^ this.getAfterTimestamp() == null) {
            return false;
        }
        if (other.getAfterTimestamp() != null && !other.getAfterTimestamp().equals(this.getAfterTimestamp())) {
            return false;
        }
        if (other.getBeforeTimestamp() == null ^ this.getBeforeTimestamp() == null) {
            return false;
        }
        if (other.getBeforeTimestamp() != null && !other.getBeforeTimestamp().equals(this.getBeforeTimestamp())) {
            return false;
        }
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null) {
            return false;
        }
        if (other.getDomainIdentifier() != null && !other.getDomainIdentifier().equals(this.getDomainIdentifier())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSubjects() == null ^ this.getSubjects() == null) {
            return false;
        }
        if (other.getSubjects() != null && !other.getSubjects().equals(this.getSubjects())) {
            return false;
        }
        if (other.getTaskStatus() == null ^ this.getTaskStatus() == null) {
            return false;
        }
        if (other.getTaskStatus() != null && !other.getTaskStatus().equals(this.getTaskStatus())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAfterTimestamp() == null ? 0 : this.getAfterTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getBeforeTimestamp() == null ? 0 : this.getBeforeTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIdentifier() == null ? 0 : this.getDomainIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSubjects() == null ? 0 : this.getSubjects().hashCode());
        hashCode = 31 * hashCode + (this.getTaskStatus() == null ? 0 : this.getTaskStatus().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public ListNotificationsRequest clone() {
        return (ListNotificationsRequest)super.clone();
    }
}

