/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datasync.model.P95Metrics;

@SdkInternalApi
public class P95MetricsMarshaller {
    private static final MarshallingInfo<StructuredPojo> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IOPS").build();
    private static final MarshallingInfo<StructuredPojo> THROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Throughput").build();
    private static final MarshallingInfo<StructuredPojo> LATENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Latency").build();
    private static final P95MetricsMarshaller instance = new P95MetricsMarshaller();

    public static P95MetricsMarshaller getInstance() {
        return instance;
    }

    public void marshall(P95Metrics p95Metrics, ProtocolMarshaller protocolMarshaller) {
        if (p95Metrics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)p95Metrics.getIOPS(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)p95Metrics.getThroughput(), THROUGHPUT_BINDING);
            protocolMarshaller.marshall((Object)p95Metrics.getLatency(), LATENCY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

