/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datasync.model.MaxP95Performance;
import com.amazonaws.services.datasync.model.Recommendation;
import com.amazonaws.services.datasync.model.RecommendationStatus;
import com.amazonaws.services.datasync.model.transform.NetAppONTAPClusterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetAppONTAPCluster
implements Serializable,
Cloneable,
StructuredPojo {
    private Long cifsShareCount;
    private Long nfsExportedVolumes;
    private String resourceId;
    private String clusterName;
    private MaxP95Performance maxP95Performance;
    private Long clusterBlockStorageSize;
    private Long clusterBlockStorageUsed;
    private Long clusterBlockStorageLogicalUsed;
    private List<Recommendation> recommendations;
    private String recommendationStatus;

    public void setCifsShareCount(Long cifsShareCount) {
        this.cifsShareCount = cifsShareCount;
    }

    public Long getCifsShareCount() {
        return this.cifsShareCount;
    }

    public NetAppONTAPCluster withCifsShareCount(Long cifsShareCount) {
        this.setCifsShareCount(cifsShareCount);
        return this;
    }

    public void setNfsExportedVolumes(Long nfsExportedVolumes) {
        this.nfsExportedVolumes = nfsExportedVolumes;
    }

    public Long getNfsExportedVolumes() {
        return this.nfsExportedVolumes;
    }

    public NetAppONTAPCluster withNfsExportedVolumes(Long nfsExportedVolumes) {
        this.setNfsExportedVolumes(nfsExportedVolumes);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public NetAppONTAPCluster withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public NetAppONTAPCluster withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setMaxP95Performance(MaxP95Performance maxP95Performance) {
        this.maxP95Performance = maxP95Performance;
    }

    public MaxP95Performance getMaxP95Performance() {
        return this.maxP95Performance;
    }

    public NetAppONTAPCluster withMaxP95Performance(MaxP95Performance maxP95Performance) {
        this.setMaxP95Performance(maxP95Performance);
        return this;
    }

    public void setClusterBlockStorageSize(Long clusterBlockStorageSize) {
        this.clusterBlockStorageSize = clusterBlockStorageSize;
    }

    public Long getClusterBlockStorageSize() {
        return this.clusterBlockStorageSize;
    }

    public NetAppONTAPCluster withClusterBlockStorageSize(Long clusterBlockStorageSize) {
        this.setClusterBlockStorageSize(clusterBlockStorageSize);
        return this;
    }

    public void setClusterBlockStorageUsed(Long clusterBlockStorageUsed) {
        this.clusterBlockStorageUsed = clusterBlockStorageUsed;
    }

    public Long getClusterBlockStorageUsed() {
        return this.clusterBlockStorageUsed;
    }

    public NetAppONTAPCluster withClusterBlockStorageUsed(Long clusterBlockStorageUsed) {
        this.setClusterBlockStorageUsed(clusterBlockStorageUsed);
        return this;
    }

    public void setClusterBlockStorageLogicalUsed(Long clusterBlockStorageLogicalUsed) {
        this.clusterBlockStorageLogicalUsed = clusterBlockStorageLogicalUsed;
    }

    public Long getClusterBlockStorageLogicalUsed() {
        return this.clusterBlockStorageLogicalUsed;
    }

    public NetAppONTAPCluster withClusterBlockStorageLogicalUsed(Long clusterBlockStorageLogicalUsed) {
        this.setClusterBlockStorageLogicalUsed(clusterBlockStorageLogicalUsed);
        return this;
    }

    public List<Recommendation> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(Collection<Recommendation> recommendations) {
        if (recommendations == null) {
            this.recommendations = null;
            return;
        }
        this.recommendations = new ArrayList<Recommendation>(recommendations);
    }

    public NetAppONTAPCluster withRecommendations(Recommendation ... recommendations) {
        if (this.recommendations == null) {
            this.setRecommendations(new ArrayList<Recommendation>(recommendations.length));
        }
        for (Recommendation ele : recommendations) {
            this.recommendations.add(ele);
        }
        return this;
    }

    public NetAppONTAPCluster withRecommendations(Collection<Recommendation> recommendations) {
        this.setRecommendations(recommendations);
        return this;
    }

    public void setRecommendationStatus(String recommendationStatus) {
        this.recommendationStatus = recommendationStatus;
    }

    public String getRecommendationStatus() {
        return this.recommendationStatus;
    }

    public NetAppONTAPCluster withRecommendationStatus(String recommendationStatus) {
        this.setRecommendationStatus(recommendationStatus);
        return this;
    }

    public NetAppONTAPCluster withRecommendationStatus(RecommendationStatus recommendationStatus) {
        this.recommendationStatus = recommendationStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCifsShareCount() != null) {
            sb.append("CifsShareCount: ").append(this.getCifsShareCount()).append(",");
        }
        if (this.getNfsExportedVolumes() != null) {
            sb.append("NfsExportedVolumes: ").append(this.getNfsExportedVolumes()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getMaxP95Performance() != null) {
            sb.append("MaxP95Performance: ").append(this.getMaxP95Performance()).append(",");
        }
        if (this.getClusterBlockStorageSize() != null) {
            sb.append("ClusterBlockStorageSize: ").append(this.getClusterBlockStorageSize()).append(",");
        }
        if (this.getClusterBlockStorageUsed() != null) {
            sb.append("ClusterBlockStorageUsed: ").append(this.getClusterBlockStorageUsed()).append(",");
        }
        if (this.getClusterBlockStorageLogicalUsed() != null) {
            sb.append("ClusterBlockStorageLogicalUsed: ").append(this.getClusterBlockStorageLogicalUsed()).append(",");
        }
        if (this.getRecommendations() != null) {
            sb.append("Recommendations: ").append(this.getRecommendations()).append(",");
        }
        if (this.getRecommendationStatus() != null) {
            sb.append("RecommendationStatus: ").append(this.getRecommendationStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetAppONTAPCluster)) {
            return false;
        }
        NetAppONTAPCluster other = (NetAppONTAPCluster)obj;
        if (other.getCifsShareCount() == null ^ this.getCifsShareCount() == null) {
            return false;
        }
        if (other.getCifsShareCount() != null && !other.getCifsShareCount().equals(this.getCifsShareCount())) {
            return false;
        }
        if (other.getNfsExportedVolumes() == null ^ this.getNfsExportedVolumes() == null) {
            return false;
        }
        if (other.getNfsExportedVolumes() != null && !other.getNfsExportedVolumes().equals(this.getNfsExportedVolumes())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getMaxP95Performance() == null ^ this.getMaxP95Performance() == null) {
            return false;
        }
        if (other.getMaxP95Performance() != null && !other.getMaxP95Performance().equals(this.getMaxP95Performance())) {
            return false;
        }
        if (other.getClusterBlockStorageSize() == null ^ this.getClusterBlockStorageSize() == null) {
            return false;
        }
        if (other.getClusterBlockStorageSize() != null && !other.getClusterBlockStorageSize().equals(this.getClusterBlockStorageSize())) {
            return false;
        }
        if (other.getClusterBlockStorageUsed() == null ^ this.getClusterBlockStorageUsed() == null) {
            return false;
        }
        if (other.getClusterBlockStorageUsed() != null && !other.getClusterBlockStorageUsed().equals(this.getClusterBlockStorageUsed())) {
            return false;
        }
        if (other.getClusterBlockStorageLogicalUsed() == null ^ this.getClusterBlockStorageLogicalUsed() == null) {
            return false;
        }
        if (other.getClusterBlockStorageLogicalUsed() != null && !other.getClusterBlockStorageLogicalUsed().equals(this.getClusterBlockStorageLogicalUsed())) {
            return false;
        }
        if (other.getRecommendations() == null ^ this.getRecommendations() == null) {
            return false;
        }
        if (other.getRecommendations() != null && !other.getRecommendations().equals(this.getRecommendations())) {
            return false;
        }
        if (other.getRecommendationStatus() == null ^ this.getRecommendationStatus() == null) {
            return false;
        }
        return other.getRecommendationStatus() == null || other.getRecommendationStatus().equals(this.getRecommendationStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCifsShareCount() == null ? 0 : this.getCifsShareCount().hashCode());
        hashCode = 31 * hashCode + (this.getNfsExportedVolumes() == null ? 0 : this.getNfsExportedVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getMaxP95Performance() == null ? 0 : this.getMaxP95Performance().hashCode());
        hashCode = 31 * hashCode + (this.getClusterBlockStorageSize() == null ? 0 : this.getClusterBlockStorageSize().hashCode());
        hashCode = 31 * hashCode + (this.getClusterBlockStorageUsed() == null ? 0 : this.getClusterBlockStorageUsed().hashCode());
        hashCode = 31 * hashCode + (this.getClusterBlockStorageLogicalUsed() == null ? 0 : this.getClusterBlockStorageLogicalUsed().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendations() == null ? 0 : this.getRecommendations().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationStatus() == null ? 0 : this.getRecommendationStatus().hashCode());
        return hashCode;
    }

    public NetAppONTAPCluster clone() {
        try {
            return (NetAppONTAPCluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetAppONTAPClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

