/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.datasync.AWSDataSync;
import com.amazonaws.services.datasync.AWSDataSyncClientBuilder;
import com.amazonaws.services.datasync.model.AWSDataSyncException;
import com.amazonaws.services.datasync.model.CancelTaskExecutionRequest;
import com.amazonaws.services.datasync.model.CancelTaskExecutionResult;
import com.amazonaws.services.datasync.model.CreateAgentRequest;
import com.amazonaws.services.datasync.model.CreateAgentResult;
import com.amazonaws.services.datasync.model.CreateLocationEfsRequest;
import com.amazonaws.services.datasync.model.CreateLocationEfsResult;
import com.amazonaws.services.datasync.model.CreateLocationNfsRequest;
import com.amazonaws.services.datasync.model.CreateLocationNfsResult;
import com.amazonaws.services.datasync.model.CreateLocationS3Request;
import com.amazonaws.services.datasync.model.CreateLocationS3Result;
import com.amazonaws.services.datasync.model.CreateLocationSmbRequest;
import com.amazonaws.services.datasync.model.CreateLocationSmbResult;
import com.amazonaws.services.datasync.model.CreateTaskRequest;
import com.amazonaws.services.datasync.model.CreateTaskResult;
import com.amazonaws.services.datasync.model.DeleteAgentRequest;
import com.amazonaws.services.datasync.model.DeleteAgentResult;
import com.amazonaws.services.datasync.model.DeleteLocationRequest;
import com.amazonaws.services.datasync.model.DeleteLocationResult;
import com.amazonaws.services.datasync.model.DeleteTaskRequest;
import com.amazonaws.services.datasync.model.DeleteTaskResult;
import com.amazonaws.services.datasync.model.DescribeAgentRequest;
import com.amazonaws.services.datasync.model.DescribeAgentResult;
import com.amazonaws.services.datasync.model.DescribeLocationEfsRequest;
import com.amazonaws.services.datasync.model.DescribeLocationEfsResult;
import com.amazonaws.services.datasync.model.DescribeLocationNfsRequest;
import com.amazonaws.services.datasync.model.DescribeLocationNfsResult;
import com.amazonaws.services.datasync.model.DescribeLocationS3Request;
import com.amazonaws.services.datasync.model.DescribeLocationS3Result;
import com.amazonaws.services.datasync.model.DescribeLocationSmbRequest;
import com.amazonaws.services.datasync.model.DescribeLocationSmbResult;
import com.amazonaws.services.datasync.model.DescribeTaskExecutionRequest;
import com.amazonaws.services.datasync.model.DescribeTaskExecutionResult;
import com.amazonaws.services.datasync.model.DescribeTaskRequest;
import com.amazonaws.services.datasync.model.DescribeTaskResult;
import com.amazonaws.services.datasync.model.InternalException;
import com.amazonaws.services.datasync.model.InvalidRequestException;
import com.amazonaws.services.datasync.model.ListAgentsRequest;
import com.amazonaws.services.datasync.model.ListAgentsResult;
import com.amazonaws.services.datasync.model.ListLocationsRequest;
import com.amazonaws.services.datasync.model.ListLocationsResult;
import com.amazonaws.services.datasync.model.ListTagsForResourceRequest;
import com.amazonaws.services.datasync.model.ListTagsForResourceResult;
import com.amazonaws.services.datasync.model.ListTaskExecutionsRequest;
import com.amazonaws.services.datasync.model.ListTaskExecutionsResult;
import com.amazonaws.services.datasync.model.ListTasksRequest;
import com.amazonaws.services.datasync.model.ListTasksResult;
import com.amazonaws.services.datasync.model.StartTaskExecutionRequest;
import com.amazonaws.services.datasync.model.StartTaskExecutionResult;
import com.amazonaws.services.datasync.model.TagResourceRequest;
import com.amazonaws.services.datasync.model.TagResourceResult;
import com.amazonaws.services.datasync.model.UntagResourceRequest;
import com.amazonaws.services.datasync.model.UntagResourceResult;
import com.amazonaws.services.datasync.model.UpdateAgentRequest;
import com.amazonaws.services.datasync.model.UpdateAgentResult;
import com.amazonaws.services.datasync.model.UpdateTaskRequest;
import com.amazonaws.services.datasync.model.UpdateTaskResult;
import com.amazonaws.services.datasync.model.transform.CancelTaskExecutionRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.CancelTaskExecutionResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.CreateAgentRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.CreateAgentResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationEfsRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationEfsResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationNfsRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationNfsResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationS3RequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationS3ResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationSmbRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.CreateLocationSmbResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.CreateTaskRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.CreateTaskResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DeleteAgentRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DeleteAgentResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DeleteLocationRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DeleteLocationResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DeleteTaskRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DeleteTaskResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeAgentRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeAgentResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationEfsRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationEfsResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationNfsRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationNfsResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationS3RequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationS3ResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationSmbRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeLocationSmbResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeTaskExecutionRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeTaskExecutionResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeTaskRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.DescribeTaskResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.ListAgentsRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.ListAgentsResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.ListLocationsRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.ListLocationsResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.ListTaskExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.ListTaskExecutionsResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.ListTasksRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.ListTasksResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.StartTaskExecutionRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.StartTaskExecutionResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.UpdateAgentRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.UpdateAgentResultJsonUnmarshaller;
import com.amazonaws.services.datasync.model.transform.UpdateTaskRequestProtocolMarshaller;
import com.amazonaws.services.datasync.model.transform.UpdateTaskResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSDataSyncClient
extends AmazonWebServiceClient
implements AWSDataSync {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSDataSync.class);
    private static final String DEFAULT_SIGNING_NAME = "datasync";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalException").withModeledClass(InternalException.class)).withBaseServiceExceptionClass(AWSDataSyncException.class));

    public static AWSDataSyncClientBuilder builder() {
        return AWSDataSyncClientBuilder.standard();
    }

    AWSDataSyncClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSDataSyncClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("datasync.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/datasync/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/datasync/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelTaskExecutionResult cancelTaskExecution(CancelTaskExecutionRequest request) {
        request = (CancelTaskExecutionRequest)this.beforeClientExecution(request);
        return this.executeCancelTaskExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelTaskExecutionResult executeCancelTaskExecution(CancelTaskExecutionRequest cancelTaskExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelTaskExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelTaskExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelTaskExecutionRequestProtocolMarshaller(protocolFactory).marshall((CancelTaskExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelTaskExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelTaskExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelTaskExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelTaskExecutionResult cancelTaskExecutionResult = (CancelTaskExecutionResult)response.getAwsResponse();
            return cancelTaskExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAgentResult createAgent(CreateAgentRequest request) {
        request = (CreateAgentRequest)this.beforeClientExecution(request);
        return this.executeCreateAgent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAgentResult executeCreateAgent(CreateAgentRequest createAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAgentRequestProtocolMarshaller(protocolFactory).marshall((CreateAgentRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAgent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAgentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAgentResult createAgentResult = (CreateAgentResult)response.getAwsResponse();
            return createAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLocationEfsResult createLocationEfs(CreateLocationEfsRequest request) {
        request = (CreateLocationEfsRequest)this.beforeClientExecution(request);
        return this.executeCreateLocationEfs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLocationEfsResult executeCreateLocationEfs(CreateLocationEfsRequest createLocationEfsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLocationEfsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLocationEfsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLocationEfsRequestProtocolMarshaller(protocolFactory).marshall((CreateLocationEfsRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLocationEfsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLocationEfs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLocationEfsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLocationEfsResult createLocationEfsResult = (CreateLocationEfsResult)response.getAwsResponse();
            return createLocationEfsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLocationNfsResult createLocationNfs(CreateLocationNfsRequest request) {
        request = (CreateLocationNfsRequest)this.beforeClientExecution(request);
        return this.executeCreateLocationNfs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLocationNfsResult executeCreateLocationNfs(CreateLocationNfsRequest createLocationNfsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLocationNfsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLocationNfsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLocationNfsRequestProtocolMarshaller(protocolFactory).marshall((CreateLocationNfsRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLocationNfsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLocationNfs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLocationNfsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLocationNfsResult createLocationNfsResult = (CreateLocationNfsResult)response.getAwsResponse();
            return createLocationNfsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLocationS3Result createLocationS3(CreateLocationS3Request request) {
        request = (CreateLocationS3Request)this.beforeClientExecution(request);
        return this.executeCreateLocationS3(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLocationS3Result executeCreateLocationS3(CreateLocationS3Request createLocationS3Request) {
        ExecutionContext executionContext = this.createExecutionContext(createLocationS3Request);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLocationS3Request> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLocationS3RequestProtocolMarshaller(protocolFactory).marshall((CreateLocationS3Request)super.beforeMarshalling((AmazonWebServiceRequest)createLocationS3Request));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLocationS3");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLocationS3ResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLocationS3Result createLocationS3Result = (CreateLocationS3Result)response.getAwsResponse();
            return createLocationS3Result;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLocationSmbResult createLocationSmb(CreateLocationSmbRequest request) {
        request = (CreateLocationSmbRequest)this.beforeClientExecution(request);
        return this.executeCreateLocationSmb(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLocationSmbResult executeCreateLocationSmb(CreateLocationSmbRequest createLocationSmbRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLocationSmbRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLocationSmbRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLocationSmbRequestProtocolMarshaller(protocolFactory).marshall((CreateLocationSmbRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLocationSmbRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLocationSmb");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLocationSmbResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLocationSmbResult createLocationSmbResult = (CreateLocationSmbResult)response.getAwsResponse();
            return createLocationSmbResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTaskResult createTask(CreateTaskRequest request) {
        request = (CreateTaskRequest)this.beforeClientExecution(request);
        return this.executeCreateTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTaskResult executeCreateTask(CreateTaskRequest createTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTaskRequestProtocolMarshaller(protocolFactory).marshall((CreateTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTaskResult createTaskResult = (CreateTaskResult)response.getAwsResponse();
            return createTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAgentResult deleteAgent(DeleteAgentRequest request) {
        request = (DeleteAgentRequest)this.beforeClientExecution(request);
        return this.executeDeleteAgent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAgentResult executeDeleteAgent(DeleteAgentRequest deleteAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAgentRequestProtocolMarshaller(protocolFactory).marshall((DeleteAgentRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAgent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAgentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAgentResult deleteAgentResult = (DeleteAgentResult)response.getAwsResponse();
            return deleteAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLocationResult deleteLocation(DeleteLocationRequest request) {
        request = (DeleteLocationRequest)this.beforeClientExecution(request);
        return this.executeDeleteLocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLocationResult executeDeleteLocation(DeleteLocationRequest deleteLocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLocationRequestProtocolMarshaller(protocolFactory).marshall((DeleteLocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLocationResult deleteLocationResult = (DeleteLocationResult)response.getAwsResponse();
            return deleteLocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTaskResult deleteTask(DeleteTaskRequest request) {
        request = (DeleteTaskRequest)this.beforeClientExecution(request);
        return this.executeDeleteTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTaskResult executeDeleteTask(DeleteTaskRequest deleteTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTaskRequestProtocolMarshaller(protocolFactory).marshall((DeleteTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTaskResult deleteTaskResult = (DeleteTaskResult)response.getAwsResponse();
            return deleteTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAgentResult describeAgent(DescribeAgentRequest request) {
        request = (DescribeAgentRequest)this.beforeClientExecution(request);
        return this.executeDescribeAgent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAgentResult executeDescribeAgent(DescribeAgentRequest describeAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAgentRequestProtocolMarshaller(protocolFactory).marshall((DescribeAgentRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAgent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAgentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAgentResult describeAgentResult = (DescribeAgentResult)response.getAwsResponse();
            return describeAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLocationEfsResult describeLocationEfs(DescribeLocationEfsRequest request) {
        request = (DescribeLocationEfsRequest)this.beforeClientExecution(request);
        return this.executeDescribeLocationEfs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLocationEfsResult executeDescribeLocationEfs(DescribeLocationEfsRequest describeLocationEfsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLocationEfsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLocationEfsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLocationEfsRequestProtocolMarshaller(protocolFactory).marshall((DescribeLocationEfsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLocationEfsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLocationEfs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLocationEfsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLocationEfsResult describeLocationEfsResult = (DescribeLocationEfsResult)response.getAwsResponse();
            return describeLocationEfsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLocationNfsResult describeLocationNfs(DescribeLocationNfsRequest request) {
        request = (DescribeLocationNfsRequest)this.beforeClientExecution(request);
        return this.executeDescribeLocationNfs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLocationNfsResult executeDescribeLocationNfs(DescribeLocationNfsRequest describeLocationNfsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLocationNfsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLocationNfsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLocationNfsRequestProtocolMarshaller(protocolFactory).marshall((DescribeLocationNfsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLocationNfsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLocationNfs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLocationNfsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLocationNfsResult describeLocationNfsResult = (DescribeLocationNfsResult)response.getAwsResponse();
            return describeLocationNfsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLocationS3Result describeLocationS3(DescribeLocationS3Request request) {
        request = (DescribeLocationS3Request)this.beforeClientExecution(request);
        return this.executeDescribeLocationS3(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLocationS3Result executeDescribeLocationS3(DescribeLocationS3Request describeLocationS3Request) {
        ExecutionContext executionContext = this.createExecutionContext(describeLocationS3Request);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLocationS3Request> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLocationS3RequestProtocolMarshaller(protocolFactory).marshall((DescribeLocationS3Request)super.beforeMarshalling((AmazonWebServiceRequest)describeLocationS3Request));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLocationS3");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLocationS3ResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLocationS3Result describeLocationS3Result = (DescribeLocationS3Result)response.getAwsResponse();
            return describeLocationS3Result;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLocationSmbResult describeLocationSmb(DescribeLocationSmbRequest request) {
        request = (DescribeLocationSmbRequest)this.beforeClientExecution(request);
        return this.executeDescribeLocationSmb(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLocationSmbResult executeDescribeLocationSmb(DescribeLocationSmbRequest describeLocationSmbRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLocationSmbRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLocationSmbRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLocationSmbRequestProtocolMarshaller(protocolFactory).marshall((DescribeLocationSmbRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLocationSmbRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLocationSmb");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLocationSmbResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLocationSmbResult describeLocationSmbResult = (DescribeLocationSmbResult)response.getAwsResponse();
            return describeLocationSmbResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTaskResult describeTask(DescribeTaskRequest request) {
        request = (DescribeTaskRequest)this.beforeClientExecution(request);
        return this.executeDescribeTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTaskResult executeDescribeTask(DescribeTaskRequest describeTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTaskRequestProtocolMarshaller(protocolFactory).marshall((DescribeTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTaskResult describeTaskResult = (DescribeTaskResult)response.getAwsResponse();
            return describeTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTaskExecutionResult describeTaskExecution(DescribeTaskExecutionRequest request) {
        request = (DescribeTaskExecutionRequest)this.beforeClientExecution(request);
        return this.executeDescribeTaskExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTaskExecutionResult executeDescribeTaskExecution(DescribeTaskExecutionRequest describeTaskExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTaskExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTaskExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTaskExecutionRequestProtocolMarshaller(protocolFactory).marshall((DescribeTaskExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTaskExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTaskExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTaskExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTaskExecutionResult describeTaskExecutionResult = (DescribeTaskExecutionResult)response.getAwsResponse();
            return describeTaskExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAgentsResult listAgents(ListAgentsRequest request) {
        request = (ListAgentsRequest)this.beforeClientExecution(request);
        return this.executeListAgents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAgentsResult executeListAgents(ListAgentsRequest listAgentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAgentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAgentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAgentsRequestProtocolMarshaller(protocolFactory).marshall((ListAgentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAgentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAgents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAgentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAgentsResult listAgentsResult = (ListAgentsResult)response.getAwsResponse();
            return listAgentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLocationsResult listLocations(ListLocationsRequest request) {
        request = (ListLocationsRequest)this.beforeClientExecution(request);
        return this.executeListLocations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLocationsResult executeListLocations(ListLocationsRequest listLocationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLocationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLocationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLocationsRequestProtocolMarshaller(protocolFactory).marshall((ListLocationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLocationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLocations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLocationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLocationsResult listLocationsResult = (ListLocationsResult)response.getAwsResponse();
            return listLocationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTaskExecutionsResult listTaskExecutions(ListTaskExecutionsRequest request) {
        request = (ListTaskExecutionsRequest)this.beforeClientExecution(request);
        return this.executeListTaskExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTaskExecutionsResult executeListTaskExecutions(ListTaskExecutionsRequest listTaskExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaskExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaskExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaskExecutionsRequestProtocolMarshaller(protocolFactory).marshall((ListTaskExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTaskExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTaskExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTaskExecutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTaskExecutionsResult listTaskExecutionsResult = (ListTaskExecutionsResult)response.getAwsResponse();
            return listTaskExecutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTasksResult listTasks(ListTasksRequest request) {
        request = (ListTasksRequest)this.beforeClientExecution(request);
        return this.executeListTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTasksResult executeListTasks(ListTasksRequest listTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTasksRequestProtocolMarshaller(protocolFactory).marshall((ListTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTasksResult listTasksResult = (ListTasksResult)response.getAwsResponse();
            return listTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTaskExecutionResult startTaskExecution(StartTaskExecutionRequest request) {
        request = (StartTaskExecutionRequest)this.beforeClientExecution(request);
        return this.executeStartTaskExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTaskExecutionResult executeStartTaskExecution(StartTaskExecutionRequest startTaskExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTaskExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTaskExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTaskExecutionRequestProtocolMarshaller(protocolFactory).marshall((StartTaskExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTaskExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTaskExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTaskExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTaskExecutionResult startTaskExecutionResult = (StartTaskExecutionResult)response.getAwsResponse();
            return startTaskExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAgentResult updateAgent(UpdateAgentRequest request) {
        request = (UpdateAgentRequest)this.beforeClientExecution(request);
        return this.executeUpdateAgent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAgentResult executeUpdateAgent(UpdateAgentRequest updateAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAgentRequestProtocolMarshaller(protocolFactory).marshall((UpdateAgentRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAgent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAgentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAgentResult updateAgentResult = (UpdateAgentResult)response.getAwsResponse();
            return updateAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTaskResult updateTask(UpdateTaskRequest request) {
        request = (UpdateTaskRequest)this.beforeClientExecution(request);
        return this.executeUpdateTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTaskResult executeUpdateTask(UpdateTaskRequest updateTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTaskRequestProtocolMarshaller(protocolFactory).marshall((UpdateTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataSync");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTaskResult updateTaskResult = (UpdateTaskResult)response.getAwsResponse();
            return updateTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

