/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.datapipeline.DataPipelineAsync;
import com.amazonaws.services.datapipeline.DataPipelineAsyncClientBuilder;
import com.amazonaws.services.datapipeline.DataPipelineClient;
import com.amazonaws.services.datapipeline.model.ActivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.ActivatePipelineResult;
import com.amazonaws.services.datapipeline.model.AddTagsRequest;
import com.amazonaws.services.datapipeline.model.AddTagsResult;
import com.amazonaws.services.datapipeline.model.CreatePipelineRequest;
import com.amazonaws.services.datapipeline.model.CreatePipelineResult;
import com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.DeactivatePipelineResult;
import com.amazonaws.services.datapipeline.model.DeletePipelineRequest;
import com.amazonaws.services.datapipeline.model.DeletePipelineResult;
import com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsResult;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.services.datapipeline.model.DescribePipelinesResult;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionResult;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.ListPipelinesRequest;
import com.amazonaws.services.datapipeline.model.ListPipelinesResult;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.PollForTaskResult;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.QueryObjectsResult;
import com.amazonaws.services.datapipeline.model.RemoveTagsRequest;
import com.amazonaws.services.datapipeline.model.RemoveTagsResult;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressResult;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatResult;
import com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.amazonaws.services.datapipeline.model.SetStatusResult;
import com.amazonaws.services.datapipeline.model.SetTaskStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusResult;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class DataPipelineAsyncClient
extends DataPipelineClient
implements DataPipelineAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public DataPipelineAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public DataPipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public DataPipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public DataPipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public DataPipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static DataPipelineAsyncClientBuilder asyncBuilder() {
        return DataPipelineAsyncClientBuilder.standard();
    }

    DataPipelineAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    DataPipelineAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ActivatePipelineResult> activatePipelineAsync(ActivatePipelineRequest request) {
        return this.activatePipelineAsync(request, null);
    }

    @Override
    public Future<ActivatePipelineResult> activatePipelineAsync(ActivatePipelineRequest request, final AsyncHandler<ActivatePipelineRequest, ActivatePipelineResult> asyncHandler) {
        final ActivatePipelineRequest finalRequest = (ActivatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivatePipelineResult>(){

            @Override
            public ActivatePipelineResult call() throws Exception {
                ActivatePipelineResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeActivatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        final AddTagsRequest finalRequest = (AddTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeAddTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        final CreatePipelineRequest finalRequest = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeCreatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeactivatePipelineResult> deactivatePipelineAsync(DeactivatePipelineRequest request) {
        return this.deactivatePipelineAsync(request, null);
    }

    @Override
    public Future<DeactivatePipelineResult> deactivatePipelineAsync(DeactivatePipelineRequest request, final AsyncHandler<DeactivatePipelineRequest, DeactivatePipelineResult> asyncHandler) {
        final DeactivatePipelineRequest finalRequest = (DeactivatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeactivatePipelineResult>(){

            @Override
            public DeactivatePipelineResult call() throws Exception {
                DeactivatePipelineResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeDeactivatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) {
        final DeletePipelineRequest finalRequest = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeDeletePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeObjectsResult> describeObjectsAsync(DescribeObjectsRequest request) {
        return this.describeObjectsAsync(request, null);
    }

    @Override
    public Future<DescribeObjectsResult> describeObjectsAsync(DescribeObjectsRequest request, final AsyncHandler<DescribeObjectsRequest, DescribeObjectsResult> asyncHandler) {
        final DescribeObjectsRequest finalRequest = (DescribeObjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeObjectsResult>(){

            @Override
            public DescribeObjectsResult call() throws Exception {
                DescribeObjectsResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeDescribeObjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePipelinesResult> describePipelinesAsync(DescribePipelinesRequest request) {
        return this.describePipelinesAsync(request, null);
    }

    @Override
    public Future<DescribePipelinesResult> describePipelinesAsync(DescribePipelinesRequest request, final AsyncHandler<DescribePipelinesRequest, DescribePipelinesResult> asyncHandler) {
        final DescribePipelinesRequest finalRequest = (DescribePipelinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePipelinesResult>(){

            @Override
            public DescribePipelinesResult call() throws Exception {
                DescribePipelinesResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeDescribePipelines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EvaluateExpressionResult> evaluateExpressionAsync(EvaluateExpressionRequest request) {
        return this.evaluateExpressionAsync(request, null);
    }

    @Override
    public Future<EvaluateExpressionResult> evaluateExpressionAsync(EvaluateExpressionRequest request, final AsyncHandler<EvaluateExpressionRequest, EvaluateExpressionResult> asyncHandler) {
        final EvaluateExpressionRequest finalRequest = (EvaluateExpressionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EvaluateExpressionResult>(){

            @Override
            public EvaluateExpressionResult call() throws Exception {
                EvaluateExpressionResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeEvaluateExpression(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineDefinitionResult> getPipelineDefinitionAsync(GetPipelineDefinitionRequest request) {
        return this.getPipelineDefinitionAsync(request, null);
    }

    @Override
    public Future<GetPipelineDefinitionResult> getPipelineDefinitionAsync(GetPipelineDefinitionRequest request, final AsyncHandler<GetPipelineDefinitionRequest, GetPipelineDefinitionResult> asyncHandler) {
        final GetPipelineDefinitionRequest finalRequest = (GetPipelineDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPipelineDefinitionResult>(){

            @Override
            public GetPipelineDefinitionResult call() throws Exception {
                GetPipelineDefinitionResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeGetPipelineDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        final ListPipelinesRequest finalRequest = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeListPipelines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync() {
        return this.listPipelinesAsync(new ListPipelinesRequest());
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.listPipelinesAsync(new ListPipelinesRequest(), asyncHandler);
    }

    @Override
    public Future<PollForTaskResult> pollForTaskAsync(PollForTaskRequest request) {
        return this.pollForTaskAsync(request, null);
    }

    @Override
    public Future<PollForTaskResult> pollForTaskAsync(PollForTaskRequest request, final AsyncHandler<PollForTaskRequest, PollForTaskResult> asyncHandler) {
        final PollForTaskRequest finalRequest = (PollForTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PollForTaskResult>(){

            @Override
            public PollForTaskResult call() throws Exception {
                PollForTaskResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executePollForTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPipelineDefinitionResult> putPipelineDefinitionAsync(PutPipelineDefinitionRequest request) {
        return this.putPipelineDefinitionAsync(request, null);
    }

    @Override
    public Future<PutPipelineDefinitionResult> putPipelineDefinitionAsync(PutPipelineDefinitionRequest request, final AsyncHandler<PutPipelineDefinitionRequest, PutPipelineDefinitionResult> asyncHandler) {
        final PutPipelineDefinitionRequest finalRequest = (PutPipelineDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPipelineDefinitionResult>(){

            @Override
            public PutPipelineDefinitionResult call() throws Exception {
                PutPipelineDefinitionResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executePutPipelineDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<QueryObjectsResult> queryObjectsAsync(QueryObjectsRequest request) {
        return this.queryObjectsAsync(request, null);
    }

    @Override
    public Future<QueryObjectsResult> queryObjectsAsync(QueryObjectsRequest request, final AsyncHandler<QueryObjectsRequest, QueryObjectsResult> asyncHandler) {
        final QueryObjectsRequest finalRequest = (QueryObjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<QueryObjectsResult>(){

            @Override
            public QueryObjectsResult call() throws Exception {
                QueryObjectsResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeQueryObjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request) {
        return this.removeTagsAsync(request, null);
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request, final AsyncHandler<RemoveTagsRequest, RemoveTagsResult> asyncHandler) {
        final RemoveTagsRequest finalRequest = (RemoveTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                RemoveTagsResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeRemoveTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReportTaskProgressResult> reportTaskProgressAsync(ReportTaskProgressRequest request) {
        return this.reportTaskProgressAsync(request, null);
    }

    @Override
    public Future<ReportTaskProgressResult> reportTaskProgressAsync(ReportTaskProgressRequest request, final AsyncHandler<ReportTaskProgressRequest, ReportTaskProgressResult> asyncHandler) {
        final ReportTaskProgressRequest finalRequest = (ReportTaskProgressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReportTaskProgressResult>(){

            @Override
            public ReportTaskProgressResult call() throws Exception {
                ReportTaskProgressResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeReportTaskProgress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReportTaskRunnerHeartbeatResult> reportTaskRunnerHeartbeatAsync(ReportTaskRunnerHeartbeatRequest request) {
        return this.reportTaskRunnerHeartbeatAsync(request, null);
    }

    @Override
    public Future<ReportTaskRunnerHeartbeatResult> reportTaskRunnerHeartbeatAsync(ReportTaskRunnerHeartbeatRequest request, final AsyncHandler<ReportTaskRunnerHeartbeatRequest, ReportTaskRunnerHeartbeatResult> asyncHandler) {
        final ReportTaskRunnerHeartbeatRequest finalRequest = (ReportTaskRunnerHeartbeatRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReportTaskRunnerHeartbeatResult>(){

            @Override
            public ReportTaskRunnerHeartbeatResult call() throws Exception {
                ReportTaskRunnerHeartbeatResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeReportTaskRunnerHeartbeat(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetStatusResult> setStatusAsync(SetStatusRequest request) {
        return this.setStatusAsync(request, null);
    }

    @Override
    public Future<SetStatusResult> setStatusAsync(SetStatusRequest request, final AsyncHandler<SetStatusRequest, SetStatusResult> asyncHandler) {
        final SetStatusRequest finalRequest = (SetStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetStatusResult>(){

            @Override
            public SetStatusResult call() throws Exception {
                SetStatusResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeSetStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetTaskStatusResult> setTaskStatusAsync(SetTaskStatusRequest request) {
        return this.setTaskStatusAsync(request, null);
    }

    @Override
    public Future<SetTaskStatusResult> setTaskStatusAsync(SetTaskStatusRequest request, final AsyncHandler<SetTaskStatusRequest, SetTaskStatusResult> asyncHandler) {
        final SetTaskStatusRequest finalRequest = (SetTaskStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetTaskStatusResult>(){

            @Override
            public SetTaskStatusResult call() throws Exception {
                SetTaskStatusResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeSetTaskStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ValidatePipelineDefinitionResult> validatePipelineDefinitionAsync(ValidatePipelineDefinitionRequest request) {
        return this.validatePipelineDefinitionAsync(request, null);
    }

    @Override
    public Future<ValidatePipelineDefinitionResult> validatePipelineDefinitionAsync(ValidatePipelineDefinitionRequest request, final AsyncHandler<ValidatePipelineDefinitionRequest, ValidatePipelineDefinitionResult> asyncHandler) {
        final ValidatePipelineDefinitionRequest finalRequest = (ValidatePipelineDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ValidatePipelineDefinitionResult>(){

            @Override
            public ValidatePipelineDefinitionResult call() throws Exception {
                ValidatePipelineDefinitionResult result = null;
                try {
                    result = DataPipelineAsyncClient.this.executeValidatePipelineDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

