/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.Selector;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Query
implements Serializable,
Cloneable {
    private SdkInternalList<Selector> selectors;

    public List<Selector> getSelectors() {
        if (this.selectors == null) {
            this.selectors = new SdkInternalList();
        }
        return this.selectors;
    }

    public void setSelectors(Collection<Selector> selectors) {
        if (selectors == null) {
            this.selectors = null;
            return;
        }
        this.selectors = new SdkInternalList(selectors);
    }

    public Query withSelectors(Selector ... selectors) {
        if (this.selectors == null) {
            this.setSelectors((Collection<Selector>)new SdkInternalList(selectors.length));
        }
        for (Selector ele : selectors) {
            this.selectors.add((Object)ele);
        }
        return this;
    }

    public Query withSelectors(Collection<Selector> selectors) {
        this.setSelectors(selectors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSelectors() != null) {
            sb.append("Selectors: ").append(this.getSelectors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        if (other.getSelectors() == null ^ this.getSelectors() == null) {
            return false;
        }
        return other.getSelectors() == null || other.getSelectors().equals(this.getSelectors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSelectors() == null ? 0 : this.getSelectors().hashCode());
        return hashCode;
    }

    public Query clone() {
        try {
            return (Query)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

