/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.TaskObject;
import java.util.Map;

@SdkInternalApi
public class TaskObjectMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").build();
    private static final MarshallingInfo<String> PIPELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineId").build();
    private static final MarshallingInfo<String> ATTEMPTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attemptId").build();
    private static final MarshallingInfo<Map> OBJECTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objects").build();
    private static final TaskObjectMarshaller instance = new TaskObjectMarshaller();

    public static TaskObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaskObject taskObject, ProtocolMarshaller protocolMarshaller) {
        if (taskObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taskObject.getTaskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)taskObject.getPipelineId(), PIPELINEID_BINDING);
            protocolMarshaller.marshall((Object)taskObject.getAttemptId(), ATTEMPTID_BINDING);
            protocolMarshaller.marshall(taskObject.getObjects(), OBJECTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

