/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.datapipeline.DataPipeline;
import com.amazonaws.services.datapipeline.DataPipelineClientBuilder;
import com.amazonaws.services.datapipeline.model.ActivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.ActivatePipelineResult;
import com.amazonaws.services.datapipeline.model.AddTagsRequest;
import com.amazonaws.services.datapipeline.model.AddTagsResult;
import com.amazonaws.services.datapipeline.model.CreatePipelineRequest;
import com.amazonaws.services.datapipeline.model.CreatePipelineResult;
import com.amazonaws.services.datapipeline.model.DataPipelineException;
import com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.DeactivatePipelineResult;
import com.amazonaws.services.datapipeline.model.DeletePipelineRequest;
import com.amazonaws.services.datapipeline.model.DeletePipelineResult;
import com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsResult;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.services.datapipeline.model.DescribePipelinesResult;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionResult;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.InternalServiceErrorException;
import com.amazonaws.services.datapipeline.model.InvalidRequestException;
import com.amazonaws.services.datapipeline.model.ListPipelinesRequest;
import com.amazonaws.services.datapipeline.model.ListPipelinesResult;
import com.amazonaws.services.datapipeline.model.PipelineDeletedException;
import com.amazonaws.services.datapipeline.model.PipelineNotFoundException;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.PollForTaskResult;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.QueryObjectsResult;
import com.amazonaws.services.datapipeline.model.RemoveTagsRequest;
import com.amazonaws.services.datapipeline.model.RemoveTagsResult;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressResult;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatResult;
import com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.amazonaws.services.datapipeline.model.SetStatusResult;
import com.amazonaws.services.datapipeline.model.SetTaskStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusResult;
import com.amazonaws.services.datapipeline.model.TaskNotFoundException;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.transform.ActivatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ActivatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.AddTagsRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.AddTagsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.CreatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DeactivatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DeactivatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DeletePipelineRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribeObjectsRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribeObjectsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribePipelinesRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribePipelinesResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.EvaluateExpressionRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.EvaluateExpressionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.GetPipelineDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.GetPipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ListPipelinesRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PollForTaskRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PollForTaskResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PutPipelineDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PutPipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.QueryObjectsRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.QueryObjectsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.RemoveTagsRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.RemoveTagsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskProgressRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskProgressResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskRunnerHeartbeatRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskRunnerHeartbeatResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetStatusRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetStatusResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetTaskStatusRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetTaskStatusResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ValidatePipelineDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ValidatePipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class DataPipelineClient
extends AmazonWebServiceClient
implements DataPipeline {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(DataPipeline.class);
    private static final String DEFAULT_SIGNING_NAME = "datapipeline";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TaskNotFoundException").withModeledClass(TaskNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineDeletedException").withModeledClass(PipelineDeletedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineNotFoundException").withModeledClass(PipelineNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceError").withModeledClass(InternalServiceErrorException.class)).withBaseServiceExceptionClass(DataPipelineException.class));

    @Deprecated
    public DataPipelineClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public DataPipelineClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public DataPipelineClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public DataPipelineClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public DataPipelineClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public DataPipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public DataPipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static DataPipelineClientBuilder builder() {
        return DataPipelineClientBuilder.standard();
    }

    DataPipelineClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("datapipeline.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/datapipeline/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/datapipeline/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivatePipelineResult activatePipeline(ActivatePipelineRequest activatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(activatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ActivatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ActivatePipelineRequestProtocolMarshaller(this.protocolFactory).marshall((ActivatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)activatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivatePipelineResult activatePipelineResult = (ActivatePipelineResult)response.getAwsResponse();
            return activatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResult addTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestProtocolMarshaller(this.protocolFactory).marshall((AddTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestProtocolMarshaller(this.protocolFactory).marshall((CreatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeactivatePipelineResult deactivatePipeline(DeactivatePipelineRequest deactivatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deactivatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeactivatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeactivatePipelineRequestProtocolMarshaller(this.protocolFactory).marshall((DeactivatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deactivatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeactivatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeactivatePipelineResult deactivatePipelineResult = (DeactivatePipelineResult)response.getAwsResponse();
            return deactivatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestProtocolMarshaller(this.protocolFactory).marshall((DeletePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePipelineResult deletePipelineResult = (DeletePipelineResult)response.getAwsResponse();
            return deletePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeObjectsResult describeObjects(DescribeObjectsRequest describeObjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeObjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeObjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeObjectsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeObjectsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeObjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeObjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeObjectsResult describeObjectsResult = (DescribeObjectsResult)response.getAwsResponse();
            return describeObjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePipelinesResult describePipelines(DescribePipelinesRequest describePipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePipelinesRequestProtocolMarshaller(this.protocolFactory).marshall((DescribePipelinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePipelinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePipelinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePipelinesResult describePipelinesResult = (DescribePipelinesResult)response.getAwsResponse();
            return describePipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluateExpressionResult evaluateExpression(EvaluateExpressionRequest evaluateExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(evaluateExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EvaluateExpressionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EvaluateExpressionRequestProtocolMarshaller(this.protocolFactory).marshall((EvaluateExpressionRequest)super.beforeMarshalling((AmazonWebServiceRequest)evaluateExpressionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EvaluateExpressionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EvaluateExpressionResult evaluateExpressionResult = (EvaluateExpressionResult)response.getAwsResponse();
            return evaluateExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineDefinitionResult getPipelineDefinition(GetPipelineDefinitionRequest getPipelineDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineDefinitionRequestProtocolMarshaller(this.protocolFactory).marshall((GetPipelineDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineDefinitionResult getPipelineDefinitionResult = (GetPipelineDefinitionResult)response.getAwsResponse();
            return getPipelineDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestProtocolMarshaller(this.protocolFactory).marshall((ListPipelinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelinesResult listPipelines() {
        return this.listPipelines(new ListPipelinesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForTaskResult pollForTask(PollForTaskRequest pollForTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForTaskRequestProtocolMarshaller(this.protocolFactory).marshall((PollForTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)pollForTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PollForTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PollForTaskResult pollForTaskResult = (PollForTaskResult)response.getAwsResponse();
            return pollForTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPipelineDefinitionResult putPipelineDefinition(PutPipelineDefinitionRequest putPipelineDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPipelineDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPipelineDefinitionRequestProtocolMarshaller(this.protocolFactory).marshall((PutPipelineDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPipelineDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutPipelineDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutPipelineDefinitionResult putPipelineDefinitionResult = (PutPipelineDefinitionResult)response.getAwsResponse();
            return putPipelineDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryObjectsResult queryObjects(QueryObjectsRequest queryObjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(queryObjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<QueryObjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new QueryObjectsRequestProtocolMarshaller(this.protocolFactory).marshall((QueryObjectsRequest)super.beforeMarshalling((AmazonWebServiceRequest)queryObjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new QueryObjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            QueryObjectsResult queryObjectsResult = (QueryObjectsResult)response.getAwsResponse();
            return queryObjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest removeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsRequestProtocolMarshaller(this.protocolFactory).marshall((RemoveTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsResult removeTagsResult = (RemoveTagsResult)response.getAwsResponse();
            return removeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportTaskProgressResult reportTaskProgress(ReportTaskProgressRequest reportTaskProgressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(reportTaskProgressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReportTaskProgressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReportTaskProgressRequestProtocolMarshaller(this.protocolFactory).marshall((ReportTaskProgressRequest)super.beforeMarshalling((AmazonWebServiceRequest)reportTaskProgressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReportTaskProgressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReportTaskProgressResult reportTaskProgressResult = (ReportTaskProgressResult)response.getAwsResponse();
            return reportTaskProgressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportTaskRunnerHeartbeatResult reportTaskRunnerHeartbeat(ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) {
        ExecutionContext executionContext = this.createExecutionContext(reportTaskRunnerHeartbeatRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReportTaskRunnerHeartbeatRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReportTaskRunnerHeartbeatRequestProtocolMarshaller(this.protocolFactory).marshall((ReportTaskRunnerHeartbeatRequest)super.beforeMarshalling((AmazonWebServiceRequest)reportTaskRunnerHeartbeatRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReportTaskRunnerHeartbeatResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReportTaskRunnerHeartbeatResult reportTaskRunnerHeartbeatResult = (ReportTaskRunnerHeartbeatResult)response.getAwsResponse();
            return reportTaskRunnerHeartbeatResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetStatusResult setStatus(SetStatusRequest setStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetStatusRequestProtocolMarshaller(this.protocolFactory).marshall((SetStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)setStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetStatusResult setStatusResult = (SetStatusResult)response.getAwsResponse();
            return setStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetTaskStatusResult setTaskStatus(SetTaskStatusRequest setTaskStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setTaskStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetTaskStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetTaskStatusRequestProtocolMarshaller(this.protocolFactory).marshall((SetTaskStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)setTaskStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetTaskStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetTaskStatusResult setTaskStatusResult = (SetTaskStatusResult)response.getAwsResponse();
            return setTaskStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatePipelineDefinitionResult validatePipelineDefinition(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(validatePipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ValidatePipelineDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ValidatePipelineDefinitionRequestProtocolMarshaller(this.protocolFactory).marshall((ValidatePipelineDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)validatePipelineDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ValidatePipelineDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ValidatePipelineDefinitionResult validatePipelineDefinitionResult = (ValidatePipelineDefinitionResult)response.getAwsResponse();
            return validatePipelineDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

