/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.S3DataAccessDetails;
import java.util.List;

@SdkInternalApi
public class S3DataAccessDetailsMarshaller {
    private static final MarshallingInfo<List> KEYPREFIXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyPrefixes").build();
    private static final MarshallingInfo<List> KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keys").build();
    private static final S3DataAccessDetailsMarshaller instance = new S3DataAccessDetailsMarshaller();

    public static S3DataAccessDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DataAccessDetails s3DataAccessDetails, ProtocolMarshaller protocolMarshaller) {
        if (s3DataAccessDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3DataAccessDetails.getKeyPrefixes(), KEYPREFIXES_BINDING);
            protocolMarshaller.marshall(s3DataAccessDetails.getKeys(), KEYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

