/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dataexchange.model.KmsKeyToGrant;
import com.amazonaws.services.dataexchange.model.transform.S3DataAccessAssetSourceEntryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3DataAccessAssetSourceEntry
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucket;
    private List<String> keyPrefixes;
    private List<String> keys;
    private List<KmsKeyToGrant> kmsKeysToGrant;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public S3DataAccessAssetSourceEntry withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public List<String> getKeyPrefixes() {
        return this.keyPrefixes;
    }

    public void setKeyPrefixes(Collection<String> keyPrefixes) {
        if (keyPrefixes == null) {
            this.keyPrefixes = null;
            return;
        }
        this.keyPrefixes = new ArrayList<String>(keyPrefixes);
    }

    public S3DataAccessAssetSourceEntry withKeyPrefixes(String ... keyPrefixes) {
        if (this.keyPrefixes == null) {
            this.setKeyPrefixes(new ArrayList<String>(keyPrefixes.length));
        }
        for (String ele : keyPrefixes) {
            this.keyPrefixes.add(ele);
        }
        return this;
    }

    public S3DataAccessAssetSourceEntry withKeyPrefixes(Collection<String> keyPrefixes) {
        this.setKeyPrefixes(keyPrefixes);
        return this;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<String> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        this.keys = new ArrayList<String>(keys);
    }

    public S3DataAccessAssetSourceEntry withKeys(String ... keys) {
        if (this.keys == null) {
            this.setKeys(new ArrayList<String>(keys.length));
        }
        for (String ele : keys) {
            this.keys.add(ele);
        }
        return this;
    }

    public S3DataAccessAssetSourceEntry withKeys(Collection<String> keys) {
        this.setKeys(keys);
        return this;
    }

    public List<KmsKeyToGrant> getKmsKeysToGrant() {
        return this.kmsKeysToGrant;
    }

    public void setKmsKeysToGrant(Collection<KmsKeyToGrant> kmsKeysToGrant) {
        if (kmsKeysToGrant == null) {
            this.kmsKeysToGrant = null;
            return;
        }
        this.kmsKeysToGrant = new ArrayList<KmsKeyToGrant>(kmsKeysToGrant);
    }

    public S3DataAccessAssetSourceEntry withKmsKeysToGrant(KmsKeyToGrant ... kmsKeysToGrant) {
        if (this.kmsKeysToGrant == null) {
            this.setKmsKeysToGrant(new ArrayList<KmsKeyToGrant>(kmsKeysToGrant.length));
        }
        for (KmsKeyToGrant ele : kmsKeysToGrant) {
            this.kmsKeysToGrant.add(ele);
        }
        return this;
    }

    public S3DataAccessAssetSourceEntry withKmsKeysToGrant(Collection<KmsKeyToGrant> kmsKeysToGrant) {
        this.setKmsKeysToGrant(kmsKeysToGrant);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getKeyPrefixes() != null) {
            sb.append("KeyPrefixes: ").append(this.getKeyPrefixes()).append(",");
        }
        if (this.getKeys() != null) {
            sb.append("Keys: ").append(this.getKeys()).append(",");
        }
        if (this.getKmsKeysToGrant() != null) {
            sb.append("KmsKeysToGrant: ").append(this.getKmsKeysToGrant());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataAccessAssetSourceEntry)) {
            return false;
        }
        S3DataAccessAssetSourceEntry other = (S3DataAccessAssetSourceEntry)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getKeyPrefixes() == null ^ this.getKeyPrefixes() == null) {
            return false;
        }
        if (other.getKeyPrefixes() != null && !other.getKeyPrefixes().equals(this.getKeyPrefixes())) {
            return false;
        }
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (other.getKeys() != null && !other.getKeys().equals(this.getKeys())) {
            return false;
        }
        if (other.getKmsKeysToGrant() == null ^ this.getKmsKeysToGrant() == null) {
            return false;
        }
        return other.getKmsKeysToGrant() == null || other.getKmsKeysToGrant().equals(this.getKmsKeysToGrant());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPrefixes() == null ? 0 : this.getKeyPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeysToGrant() == null ? 0 : this.getKmsKeysToGrant().hashCode());
        return hashCode;
    }

    public S3DataAccessAssetSourceEntry clone() {
        try {
            return (S3DataAccessAssetSourceEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataAccessAssetSourceEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

