/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.AttributeItem;
import com.amazonaws.services.customerprofiles.model.transform.AttributeDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AttributeDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AttributeItem> attributes;
    private String expression;

    public List<AttributeItem> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<AttributeItem> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<AttributeItem>(attributes);
    }

    public AttributeDetails withAttributes(AttributeItem ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<AttributeItem>(attributes.length));
        }
        for (AttributeItem ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public AttributeDetails withAttributes(Collection<AttributeItem> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public AttributeDetails withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDetails)) {
            return false;
        }
        AttributeDetails other = (AttributeDetails)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        return other.getExpression() == null || other.getExpression().equals(this.getExpression());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        return hashCode;
    }

    public AttributeDetails clone() {
        try {
            return (AttributeDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

