/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.StandardIdentifier;
import com.amazonaws.services.customerprofiles.model.transform.ObjectTypeKeyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectTypeKey
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> standardIdentifiers;
    private List<String> fieldNames;

    public List<String> getStandardIdentifiers() {
        return this.standardIdentifiers;
    }

    public void setStandardIdentifiers(Collection<String> standardIdentifiers) {
        if (standardIdentifiers == null) {
            this.standardIdentifiers = null;
            return;
        }
        this.standardIdentifiers = new ArrayList<String>(standardIdentifiers);
    }

    public ObjectTypeKey withStandardIdentifiers(String ... standardIdentifiers) {
        if (this.standardIdentifiers == null) {
            this.setStandardIdentifiers(new ArrayList<String>(standardIdentifiers.length));
        }
        for (String ele : standardIdentifiers) {
            this.standardIdentifiers.add(ele);
        }
        return this;
    }

    public ObjectTypeKey withStandardIdentifiers(Collection<String> standardIdentifiers) {
        this.setStandardIdentifiers(standardIdentifiers);
        return this;
    }

    public ObjectTypeKey withStandardIdentifiers(StandardIdentifier ... standardIdentifiers) {
        ArrayList<String> standardIdentifiersCopy = new ArrayList<String>(standardIdentifiers.length);
        for (StandardIdentifier value : standardIdentifiers) {
            standardIdentifiersCopy.add(value.toString());
        }
        if (this.getStandardIdentifiers() == null) {
            this.setStandardIdentifiers(standardIdentifiersCopy);
        } else {
            this.getStandardIdentifiers().addAll(standardIdentifiersCopy);
        }
        return this;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(Collection<String> fieldNames) {
        if (fieldNames == null) {
            this.fieldNames = null;
            return;
        }
        this.fieldNames = new ArrayList<String>(fieldNames);
    }

    public ObjectTypeKey withFieldNames(String ... fieldNames) {
        if (this.fieldNames == null) {
            this.setFieldNames(new ArrayList<String>(fieldNames.length));
        }
        for (String ele : fieldNames) {
            this.fieldNames.add(ele);
        }
        return this;
    }

    public ObjectTypeKey withFieldNames(Collection<String> fieldNames) {
        this.setFieldNames(fieldNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStandardIdentifiers() != null) {
            sb.append("StandardIdentifiers: ").append(this.getStandardIdentifiers()).append(",");
        }
        if (this.getFieldNames() != null) {
            sb.append("FieldNames: ").append(this.getFieldNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectTypeKey)) {
            return false;
        }
        ObjectTypeKey other = (ObjectTypeKey)obj;
        if (other.getStandardIdentifiers() == null ^ this.getStandardIdentifiers() == null) {
            return false;
        }
        if (other.getStandardIdentifiers() != null && !other.getStandardIdentifiers().equals(this.getStandardIdentifiers())) {
            return false;
        }
        if (other.getFieldNames() == null ^ this.getFieldNames() == null) {
            return false;
        }
        return other.getFieldNames() == null || other.getFieldNames().equals(this.getFieldNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStandardIdentifiers() == null ? 0 : this.getStandardIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getFieldNames() == null ? 0 : this.getFieldNames().hashCode());
        return hashCode;
    }

    public ObjectTypeKey clone() {
        try {
            return (ObjectTypeKey)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ObjectTypeKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

