/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costoptimizationhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.Recommendation;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class RecommendationMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<String> ACTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionType").build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currencyCode").build();
    private static final MarshallingInfo<String> CURRENTRESOURCESUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentResourceSummary").build();
    private static final MarshallingInfo<String> CURRENTRESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentResourceType").build();
    private static final MarshallingInfo<Double> ESTIMATEDMONTHLYCOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("estimatedMonthlyCost").build();
    private static final MarshallingInfo<Double> ESTIMATEDMONTHLYSAVINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("estimatedMonthlySavings").build();
    private static final MarshallingInfo<Double> ESTIMATEDSAVINGSPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("estimatedSavingsPercentage").build();
    private static final MarshallingInfo<String> IMPLEMENTATIONEFFORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("implementationEffort").build();
    private static final MarshallingInfo<Date> LASTREFRESHTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastRefreshTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RECOMMENDATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recommendationId").build();
    private static final MarshallingInfo<Integer> RECOMMENDATIONLOOKBACKPERIODINDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recommendationLookbackPeriodInDays").build();
    private static final MarshallingInfo<String> RECOMMENDEDRESOURCESUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recommendedResourceSummary").build();
    private static final MarshallingInfo<String> RECOMMENDEDRESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recommendedResourceType").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceArn").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").build();
    private static final MarshallingInfo<Boolean> RESTARTNEEDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("restartNeeded").build();
    private static final MarshallingInfo<Boolean> ROLLBACKPOSSIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rollbackPossible").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final RecommendationMarshaller instance = new RecommendationMarshaller();

    public static RecommendationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Recommendation recommendation, ProtocolMarshaller protocolMarshaller) {
        if (recommendation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recommendation.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getActionType(), ACTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getCurrencyCode(), CURRENCYCODE_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getCurrentResourceSummary(), CURRENTRESOURCESUMMARY_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getCurrentResourceType(), CURRENTRESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getEstimatedMonthlyCost(), ESTIMATEDMONTHLYCOST_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getEstimatedMonthlySavings(), ESTIMATEDMONTHLYSAVINGS_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getEstimatedSavingsPercentage(), ESTIMATEDSAVINGSPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getImplementationEffort(), IMPLEMENTATIONEFFORT_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getLastRefreshTimestamp(), LASTREFRESHTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getRecommendationId(), RECOMMENDATIONID_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getRecommendationLookbackPeriodInDays(), RECOMMENDATIONLOOKBACKPERIODINDAYS_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getRecommendedResourceSummary(), RECOMMENDEDRESOURCESUMMARY_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getRecommendedResourceType(), RECOMMENDEDRESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getRestartNeeded(), RESTARTNEEDED_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getRollbackPossible(), ROLLBACKPOSSIBLE_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(recommendation.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

