/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.AnomalySubscriptionFrequency;
import com.amazonaws.services.costexplorer.model.Expression;
import com.amazonaws.services.costexplorer.model.Subscriber;
import com.amazonaws.services.costexplorer.model.transform.AnomalySubscriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnomalySubscription
implements Serializable,
Cloneable,
StructuredPojo {
    private String subscriptionArn;
    private String accountId;
    private List<String> monitorArnList;
    private List<Subscriber> subscribers;
    @Deprecated
    private Double threshold;
    private String frequency;
    private String subscriptionName;
    private Expression thresholdExpression;

    public void setSubscriptionArn(String subscriptionArn) {
        this.subscriptionArn = subscriptionArn;
    }

    public String getSubscriptionArn() {
        return this.subscriptionArn;
    }

    public AnomalySubscription withSubscriptionArn(String subscriptionArn) {
        this.setSubscriptionArn(subscriptionArn);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public AnomalySubscription withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public List<String> getMonitorArnList() {
        return this.monitorArnList;
    }

    public void setMonitorArnList(Collection<String> monitorArnList) {
        if (monitorArnList == null) {
            this.monitorArnList = null;
            return;
        }
        this.monitorArnList = new ArrayList<String>(monitorArnList);
    }

    public AnomalySubscription withMonitorArnList(String ... monitorArnList) {
        if (this.monitorArnList == null) {
            this.setMonitorArnList(new ArrayList<String>(monitorArnList.length));
        }
        for (String ele : monitorArnList) {
            this.monitorArnList.add(ele);
        }
        return this;
    }

    public AnomalySubscription withMonitorArnList(Collection<String> monitorArnList) {
        this.setMonitorArnList(monitorArnList);
        return this;
    }

    public List<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(Collection<Subscriber> subscribers) {
        if (subscribers == null) {
            this.subscribers = null;
            return;
        }
        this.subscribers = new ArrayList<Subscriber>(subscribers);
    }

    public AnomalySubscription withSubscribers(Subscriber ... subscribers) {
        if (this.subscribers == null) {
            this.setSubscribers(new ArrayList<Subscriber>(subscribers.length));
        }
        for (Subscriber ele : subscribers) {
            this.subscribers.add(ele);
        }
        return this;
    }

    public AnomalySubscription withSubscribers(Collection<Subscriber> subscribers) {
        this.setSubscribers(subscribers);
        return this;
    }

    @Deprecated
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    @Deprecated
    public Double getThreshold() {
        return this.threshold;
    }

    @Deprecated
    public AnomalySubscription withThreshold(Double threshold) {
        this.setThreshold(threshold);
        return this;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public AnomalySubscription withFrequency(String frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public AnomalySubscription withFrequency(AnomalySubscriptionFrequency frequency) {
        this.frequency = frequency.toString();
        return this;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public AnomalySubscription withSubscriptionName(String subscriptionName) {
        this.setSubscriptionName(subscriptionName);
        return this;
    }

    public void setThresholdExpression(Expression thresholdExpression) {
        this.thresholdExpression = thresholdExpression;
    }

    public Expression getThresholdExpression() {
        return this.thresholdExpression;
    }

    public AnomalySubscription withThresholdExpression(Expression thresholdExpression) {
        this.setThresholdExpression(thresholdExpression);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubscriptionArn() != null) {
            sb.append("SubscriptionArn: ").append(this.getSubscriptionArn()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getMonitorArnList() != null) {
            sb.append("MonitorArnList: ").append(this.getMonitorArnList()).append(",");
        }
        if (this.getSubscribers() != null) {
            sb.append("Subscribers: ").append(this.getSubscribers()).append(",");
        }
        if (this.getThreshold() != null) {
            sb.append("Threshold: ").append(this.getThreshold()).append(",");
        }
        if (this.getFrequency() != null) {
            sb.append("Frequency: ").append(this.getFrequency()).append(",");
        }
        if (this.getSubscriptionName() != null) {
            sb.append("SubscriptionName: ").append(this.getSubscriptionName()).append(",");
        }
        if (this.getThresholdExpression() != null) {
            sb.append("ThresholdExpression: ").append(this.getThresholdExpression());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalySubscription)) {
            return false;
        }
        AnomalySubscription other = (AnomalySubscription)obj;
        if (other.getSubscriptionArn() == null ^ this.getSubscriptionArn() == null) {
            return false;
        }
        if (other.getSubscriptionArn() != null && !other.getSubscriptionArn().equals(this.getSubscriptionArn())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getMonitorArnList() == null ^ this.getMonitorArnList() == null) {
            return false;
        }
        if (other.getMonitorArnList() != null && !other.getMonitorArnList().equals(this.getMonitorArnList())) {
            return false;
        }
        if (other.getSubscribers() == null ^ this.getSubscribers() == null) {
            return false;
        }
        if (other.getSubscribers() != null && !other.getSubscribers().equals(this.getSubscribers())) {
            return false;
        }
        if (other.getThreshold() == null ^ this.getThreshold() == null) {
            return false;
        }
        if (other.getThreshold() != null && !other.getThreshold().equals(this.getThreshold())) {
            return false;
        }
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        if (other.getFrequency() != null && !other.getFrequency().equals(this.getFrequency())) {
            return false;
        }
        if (other.getSubscriptionName() == null ^ this.getSubscriptionName() == null) {
            return false;
        }
        if (other.getSubscriptionName() != null && !other.getSubscriptionName().equals(this.getSubscriptionName())) {
            return false;
        }
        if (other.getThresholdExpression() == null ^ this.getThresholdExpression() == null) {
            return false;
        }
        return other.getThresholdExpression() == null || other.getThresholdExpression().equals(this.getThresholdExpression());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubscriptionArn() == null ? 0 : this.getSubscriptionArn().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getMonitorArnList() == null ? 0 : this.getMonitorArnList().hashCode());
        hashCode = 31 * hashCode + (this.getSubscribers() == null ? 0 : this.getSubscribers().hashCode());
        hashCode = 31 * hashCode + (this.getThreshold() == null ? 0 : this.getThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriptionName() == null ? 0 : this.getSubscriptionName().hashCode());
        hashCode = 31 * hashCode + (this.getThresholdExpression() == null ? 0 : this.getThresholdExpression().hashCode());
        return hashCode;
    }

    public AnomalySubscription clone() {
        try {
            return (AnomalySubscription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnomalySubscriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

