/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.costexplorer.model.DateInterval;
import com.amazonaws.services.costexplorer.model.Expression;
import com.amazonaws.services.costexplorer.model.Granularity;
import com.amazonaws.services.costexplorer.model.GroupDefinition;
import com.amazonaws.services.costexplorer.model.SortDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetSavingsPlansCoverageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private DateInterval timePeriod;
    private List<GroupDefinition> groupBy;
    private String granularity;
    private Expression filter;
    private List<String> metrics;
    private String nextToken;
    private Integer maxResults;
    private SortDefinition sortBy;

    public void setTimePeriod(DateInterval timePeriod) {
        this.timePeriod = timePeriod;
    }

    public DateInterval getTimePeriod() {
        return this.timePeriod;
    }

    public GetSavingsPlansCoverageRequest withTimePeriod(DateInterval timePeriod) {
        this.setTimePeriod(timePeriod);
        return this;
    }

    public List<GroupDefinition> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(Collection<GroupDefinition> groupBy) {
        if (groupBy == null) {
            this.groupBy = null;
            return;
        }
        this.groupBy = new ArrayList<GroupDefinition>(groupBy);
    }

    public GetSavingsPlansCoverageRequest withGroupBy(GroupDefinition ... groupBy) {
        if (this.groupBy == null) {
            this.setGroupBy(new ArrayList<GroupDefinition>(groupBy.length));
        }
        for (GroupDefinition ele : groupBy) {
            this.groupBy.add(ele);
        }
        return this;
    }

    public GetSavingsPlansCoverageRequest withGroupBy(Collection<GroupDefinition> groupBy) {
        this.setGroupBy(groupBy);
        return this;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public GetSavingsPlansCoverageRequest withGranularity(String granularity) {
        this.setGranularity(granularity);
        return this;
    }

    public GetSavingsPlansCoverageRequest withGranularity(Granularity granularity) {
        this.granularity = granularity.toString();
        return this;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public GetSavingsPlansCoverageRequest withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Collection<String> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        this.metrics = new ArrayList<String>(metrics);
    }

    public GetSavingsPlansCoverageRequest withMetrics(String ... metrics) {
        if (this.metrics == null) {
            this.setMetrics(new ArrayList<String>(metrics.length));
        }
        for (String ele : metrics) {
            this.metrics.add(ele);
        }
        return this;
    }

    public GetSavingsPlansCoverageRequest withMetrics(Collection<String> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetSavingsPlansCoverageRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetSavingsPlansCoverageRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setSortBy(SortDefinition sortBy) {
        this.sortBy = sortBy;
    }

    public SortDefinition getSortBy() {
        return this.sortBy;
    }

    public GetSavingsPlansCoverageRequest withSortBy(SortDefinition sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimePeriod() != null) {
            sb.append("TimePeriod: ").append(this.getTimePeriod()).append(",");
        }
        if (this.getGroupBy() != null) {
            sb.append("GroupBy: ").append(this.getGroupBy()).append(",");
        }
        if (this.getGranularity() != null) {
            sb.append("Granularity: ").append(this.getGranularity()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansCoverageRequest)) {
            return false;
        }
        GetSavingsPlansCoverageRequest other = (GetSavingsPlansCoverageRequest)obj;
        if (other.getTimePeriod() == null ^ this.getTimePeriod() == null) {
            return false;
        }
        if (other.getTimePeriod() != null && !other.getTimePeriod().equals(this.getTimePeriod())) {
            return false;
        }
        if (other.getGroupBy() == null ^ this.getGroupBy() == null) {
            return false;
        }
        if (other.getGroupBy() != null && !other.getGroupBy().equals(this.getGroupBy())) {
            return false;
        }
        if (other.getGranularity() == null ^ this.getGranularity() == null) {
            return false;
        }
        if (other.getGranularity() != null && !other.getGranularity().equals(this.getGranularity())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        return other.getSortBy() == null || other.getSortBy().equals(this.getSortBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimePeriod() == null ? 0 : this.getTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getGroupBy() == null ? 0 : this.getGroupBy().hashCode());
        hashCode = 31 * hashCode + (this.getGranularity() == null ? 0 : this.getGranularity().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        return hashCode;
    }

    public GetSavingsPlansCoverageRequest clone() {
        return (GetSavingsPlansCoverageRequest)super.clone();
    }
}

