/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.DateInterval;
import com.amazonaws.services.costexplorer.model.Group;
import com.amazonaws.services.costexplorer.model.MetricValue;
import com.amazonaws.services.costexplorer.model.transform.ResultByTimeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultByTime
implements Serializable,
Cloneable,
StructuredPojo {
    private DateInterval timePeriod;
    private Map<String, MetricValue> total;
    private List<Group> groups;
    private Boolean estimated;

    public void setTimePeriod(DateInterval timePeriod) {
        this.timePeriod = timePeriod;
    }

    public DateInterval getTimePeriod() {
        return this.timePeriod;
    }

    public ResultByTime withTimePeriod(DateInterval timePeriod) {
        this.setTimePeriod(timePeriod);
        return this;
    }

    public Map<String, MetricValue> getTotal() {
        return this.total;
    }

    public void setTotal(Map<String, MetricValue> total) {
        this.total = total;
    }

    public ResultByTime withTotal(Map<String, MetricValue> total) {
        this.setTotal(total);
        return this;
    }

    public ResultByTime addTotalEntry(String key, MetricValue value) {
        if (null == this.total) {
            this.total = new HashMap<String, MetricValue>();
        }
        if (this.total.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.total.put(key, value);
        return this;
    }

    public ResultByTime clearTotalEntries() {
        this.total = null;
        return this;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<Group> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<Group>(groups);
    }

    public ResultByTime withGroups(Group ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<Group>(groups.length));
        }
        for (Group ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public ResultByTime withGroups(Collection<Group> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setEstimated(Boolean estimated) {
        this.estimated = estimated;
    }

    public Boolean getEstimated() {
        return this.estimated;
    }

    public ResultByTime withEstimated(Boolean estimated) {
        this.setEstimated(estimated);
        return this;
    }

    public Boolean isEstimated() {
        return this.estimated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimePeriod() != null) {
            sb.append("TimePeriod: ").append(this.getTimePeriod()).append(",");
        }
        if (this.getTotal() != null) {
            sb.append("Total: ").append(this.getTotal()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getEstimated() != null) {
            sb.append("Estimated: ").append(this.getEstimated());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultByTime)) {
            return false;
        }
        ResultByTime other = (ResultByTime)obj;
        if (other.getTimePeriod() == null ^ this.getTimePeriod() == null) {
            return false;
        }
        if (other.getTimePeriod() != null && !other.getTimePeriod().equals(this.getTimePeriod())) {
            return false;
        }
        if (other.getTotal() == null ^ this.getTotal() == null) {
            return false;
        }
        if (other.getTotal() != null && !other.getTotal().equals(this.getTotal())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getEstimated() == null ^ this.getEstimated() == null) {
            return false;
        }
        return other.getEstimated() == null || other.getEstimated().equals(this.getEstimated());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimePeriod() == null ? 0 : this.getTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getTotal() == null ? 0 : this.getTotal().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getEstimated() == null ? 0 : this.getEstimated().hashCode());
        return hashCode;
    }

    public ResultByTime clone() {
        try {
            return (ResultByTime)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultByTimeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

