/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.costexplorer.AWSCostExplorer;
import com.amazonaws.services.costexplorer.AWSCostExplorerClientBuilder;
import com.amazonaws.services.costexplorer.model.AWSCostExplorerException;
import com.amazonaws.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.CreateCostCategoryDefinitionResult;
import com.amazonaws.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.DeleteCostCategoryDefinitionResult;
import com.amazonaws.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.DescribeCostCategoryDefinitionResult;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageRequest;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageResult;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageWithResourcesResult;
import com.amazonaws.services.costexplorer.model.GetCostForecastRequest;
import com.amazonaws.services.costexplorer.model.GetCostForecastResult;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesRequest;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesResult;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageRequest;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageResult;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationResult;
import com.amazonaws.services.costexplorer.model.GetRightsizingRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetRightsizingRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansCoverageResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationResult;
import com.amazonaws.services.costexplorer.model.GetTagsRequest;
import com.amazonaws.services.costexplorer.model.GetTagsResult;
import com.amazonaws.services.costexplorer.model.GetUsageForecastRequest;
import com.amazonaws.services.costexplorer.model.GetUsageForecastResult;
import com.amazonaws.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import com.amazonaws.services.costexplorer.model.ListCostCategoryDefinitionsResult;
import com.amazonaws.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.UpdateCostCategoryDefinitionResult;
import com.amazonaws.services.costexplorer.model.transform.BillExpirationExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.CreateCostCategoryDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.CreateCostCategoryDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.DataUnavailableExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.DeleteCostCategoryDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.DeleteCostCategoryDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.DescribeCostCategoryDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.DescribeCostCategoryDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetCostAndUsageRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetCostAndUsageResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetCostAndUsageWithResourcesRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetCostAndUsageWithResourcesResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetCostForecastRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetCostForecastResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetDimensionValuesRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetDimensionValuesResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetReservationCoverageRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetReservationCoverageResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetReservationPurchaseRecommendationRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetReservationPurchaseRecommendationResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetReservationUtilizationRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetReservationUtilizationResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetRightsizingRecommendationRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetRightsizingRecommendationResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansCoverageRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansCoverageResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansPurchaseRecommendationRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansPurchaseRecommendationResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansUtilizationDetailsRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansUtilizationDetailsResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansUtilizationRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetSavingsPlansUtilizationResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetTagsRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetTagsResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetUsageForecastRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.GetUsageForecastResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.ListCostCategoryDefinitionsRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.ListCostCategoryDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.RequestChangedExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.UnresolvableUsageUnitExceptionUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.UpdateCostCategoryDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.transform.UpdateCostCategoryDefinitionResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCostExplorerClient
extends AmazonWebServiceClient
implements AWSCostExplorer {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCostExplorer.class);
    private static final String DEFAULT_SIGNING_NAME = "ce";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnresolvableUsageUnitException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnresolvableUsageUnitExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestChangedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestChangedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DataUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DataUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BillExpirationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BillExpirationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCostExplorerException.class));

    public static AWSCostExplorerClientBuilder builder() {
        return AWSCostExplorerClientBuilder.standard();
    }

    AWSCostExplorerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCostExplorerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ce.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/costexplorer/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/costexplorer/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateCostCategoryDefinitionResult createCostCategoryDefinition(CreateCostCategoryDefinitionRequest request) {
        request = (CreateCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executeCreateCostCategoryDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCostCategoryDefinitionResult executeCreateCostCategoryDefinition(CreateCostCategoryDefinitionRequest createCostCategoryDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCostCategoryDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCostCategoryDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCostCategoryDefinitionRequestProtocolMarshaller(protocolFactory).marshall((CreateCostCategoryDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCostCategoryDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCostCategoryDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCostCategoryDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCostCategoryDefinitionResult createCostCategoryDefinitionResult = (CreateCostCategoryDefinitionResult)response.getAwsResponse();
            return createCostCategoryDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCostCategoryDefinitionResult deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest request) {
        request = (DeleteCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDeleteCostCategoryDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCostCategoryDefinitionResult executeDeleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest deleteCostCategoryDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCostCategoryDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCostCategoryDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCostCategoryDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DeleteCostCategoryDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCostCategoryDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCostCategoryDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCostCategoryDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCostCategoryDefinitionResult deleteCostCategoryDefinitionResult = (DeleteCostCategoryDefinitionResult)response.getAwsResponse();
            return deleteCostCategoryDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCostCategoryDefinitionResult describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest request) {
        request = (DescribeCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDescribeCostCategoryDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCostCategoryDefinitionResult executeDescribeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest describeCostCategoryDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCostCategoryDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCostCategoryDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCostCategoryDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DescribeCostCategoryDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeCostCategoryDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeCostCategoryDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCostCategoryDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCostCategoryDefinitionResult describeCostCategoryDefinitionResult = (DescribeCostCategoryDefinitionResult)response.getAwsResponse();
            return describeCostCategoryDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCostAndUsageResult getCostAndUsage(GetCostAndUsageRequest request) {
        request = (GetCostAndUsageRequest)this.beforeClientExecution(request);
        return this.executeGetCostAndUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCostAndUsageResult executeGetCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCostAndUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCostAndUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCostAndUsageRequestProtocolMarshaller(protocolFactory).marshall((GetCostAndUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCostAndUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCostAndUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCostAndUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCostAndUsageResult getCostAndUsageResult = (GetCostAndUsageResult)response.getAwsResponse();
            return getCostAndUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCostAndUsageWithResourcesResult getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest request) {
        request = (GetCostAndUsageWithResourcesRequest)this.beforeClientExecution(request);
        return this.executeGetCostAndUsageWithResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCostAndUsageWithResourcesResult executeGetCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest getCostAndUsageWithResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCostAndUsageWithResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCostAndUsageWithResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCostAndUsageWithResourcesRequestProtocolMarshaller(protocolFactory).marshall((GetCostAndUsageWithResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCostAndUsageWithResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCostAndUsageWithResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCostAndUsageWithResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCostAndUsageWithResourcesResult getCostAndUsageWithResourcesResult = (GetCostAndUsageWithResourcesResult)response.getAwsResponse();
            return getCostAndUsageWithResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCostForecastResult getCostForecast(GetCostForecastRequest request) {
        request = (GetCostForecastRequest)this.beforeClientExecution(request);
        return this.executeGetCostForecast(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCostForecastResult executeGetCostForecast(GetCostForecastRequest getCostForecastRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCostForecastRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCostForecastRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCostForecastRequestProtocolMarshaller(protocolFactory).marshall((GetCostForecastRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCostForecastRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCostForecast");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCostForecastResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCostForecastResult getCostForecastResult = (GetCostForecastResult)response.getAwsResponse();
            return getCostForecastResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDimensionValuesResult getDimensionValues(GetDimensionValuesRequest request) {
        request = (GetDimensionValuesRequest)this.beforeClientExecution(request);
        return this.executeGetDimensionValues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDimensionValuesResult executeGetDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDimensionValuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDimensionValuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDimensionValuesRequestProtocolMarshaller(protocolFactory).marshall((GetDimensionValuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDimensionValuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDimensionValues");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDimensionValuesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDimensionValuesResult getDimensionValuesResult = (GetDimensionValuesResult)response.getAwsResponse();
            return getDimensionValuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReservationCoverageResult getReservationCoverage(GetReservationCoverageRequest request) {
        request = (GetReservationCoverageRequest)this.beforeClientExecution(request);
        return this.executeGetReservationCoverage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReservationCoverageResult executeGetReservationCoverage(GetReservationCoverageRequest getReservationCoverageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReservationCoverageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReservationCoverageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReservationCoverageRequestProtocolMarshaller(protocolFactory).marshall((GetReservationCoverageRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReservationCoverageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReservationCoverage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReservationCoverageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReservationCoverageResult getReservationCoverageResult = (GetReservationCoverageResult)response.getAwsResponse();
            return getReservationCoverageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReservationPurchaseRecommendationResult getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest request) {
        request = (GetReservationPurchaseRecommendationRequest)this.beforeClientExecution(request);
        return this.executeGetReservationPurchaseRecommendation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReservationPurchaseRecommendationResult executeGetReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReservationPurchaseRecommendationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReservationPurchaseRecommendationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReservationPurchaseRecommendationRequestProtocolMarshaller(protocolFactory).marshall((GetReservationPurchaseRecommendationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReservationPurchaseRecommendationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReservationPurchaseRecommendation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReservationPurchaseRecommendationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReservationPurchaseRecommendationResult getReservationPurchaseRecommendationResult = (GetReservationPurchaseRecommendationResult)response.getAwsResponse();
            return getReservationPurchaseRecommendationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReservationUtilizationResult getReservationUtilization(GetReservationUtilizationRequest request) {
        request = (GetReservationUtilizationRequest)this.beforeClientExecution(request);
        return this.executeGetReservationUtilization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReservationUtilizationResult executeGetReservationUtilization(GetReservationUtilizationRequest getReservationUtilizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReservationUtilizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReservationUtilizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReservationUtilizationRequestProtocolMarshaller(protocolFactory).marshall((GetReservationUtilizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReservationUtilizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReservationUtilization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReservationUtilizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReservationUtilizationResult getReservationUtilizationResult = (GetReservationUtilizationResult)response.getAwsResponse();
            return getReservationUtilizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRightsizingRecommendationResult getRightsizingRecommendation(GetRightsizingRecommendationRequest request) {
        request = (GetRightsizingRecommendationRequest)this.beforeClientExecution(request);
        return this.executeGetRightsizingRecommendation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRightsizingRecommendationResult executeGetRightsizingRecommendation(GetRightsizingRecommendationRequest getRightsizingRecommendationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRightsizingRecommendationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRightsizingRecommendationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRightsizingRecommendationRequestProtocolMarshaller(protocolFactory).marshall((GetRightsizingRecommendationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRightsizingRecommendationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRightsizingRecommendation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRightsizingRecommendationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRightsizingRecommendationResult getRightsizingRecommendationResult = (GetRightsizingRecommendationResult)response.getAwsResponse();
            return getRightsizingRecommendationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSavingsPlansCoverageResult getSavingsPlansCoverage(GetSavingsPlansCoverageRequest request) {
        request = (GetSavingsPlansCoverageRequest)this.beforeClientExecution(request);
        return this.executeGetSavingsPlansCoverage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSavingsPlansCoverageResult executeGetSavingsPlansCoverage(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSavingsPlansCoverageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSavingsPlansCoverageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSavingsPlansCoverageRequestProtocolMarshaller(protocolFactory).marshall((GetSavingsPlansCoverageRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSavingsPlansCoverageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSavingsPlansCoverage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSavingsPlansCoverageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSavingsPlansCoverageResult getSavingsPlansCoverageResult = (GetSavingsPlansCoverageResult)response.getAwsResponse();
            return getSavingsPlansCoverageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSavingsPlansPurchaseRecommendationResult getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest request) {
        request = (GetSavingsPlansPurchaseRecommendationRequest)this.beforeClientExecution(request);
        return this.executeGetSavingsPlansPurchaseRecommendation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSavingsPlansPurchaseRecommendationResult executeGetSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest getSavingsPlansPurchaseRecommendationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSavingsPlansPurchaseRecommendationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSavingsPlansPurchaseRecommendationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSavingsPlansPurchaseRecommendationRequestProtocolMarshaller(protocolFactory).marshall((GetSavingsPlansPurchaseRecommendationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSavingsPlansPurchaseRecommendationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSavingsPlansPurchaseRecommendation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSavingsPlansPurchaseRecommendationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSavingsPlansPurchaseRecommendationResult getSavingsPlansPurchaseRecommendationResult = (GetSavingsPlansPurchaseRecommendationResult)response.getAwsResponse();
            return getSavingsPlansPurchaseRecommendationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSavingsPlansUtilizationResult getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest request) {
        request = (GetSavingsPlansUtilizationRequest)this.beforeClientExecution(request);
        return this.executeGetSavingsPlansUtilization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSavingsPlansUtilizationResult executeGetSavingsPlansUtilization(GetSavingsPlansUtilizationRequest getSavingsPlansUtilizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSavingsPlansUtilizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSavingsPlansUtilizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSavingsPlansUtilizationRequestProtocolMarshaller(protocolFactory).marshall((GetSavingsPlansUtilizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSavingsPlansUtilizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSavingsPlansUtilization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSavingsPlansUtilizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSavingsPlansUtilizationResult getSavingsPlansUtilizationResult = (GetSavingsPlansUtilizationResult)response.getAwsResponse();
            return getSavingsPlansUtilizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSavingsPlansUtilizationDetailsResult getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest request) {
        request = (GetSavingsPlansUtilizationDetailsRequest)this.beforeClientExecution(request);
        return this.executeGetSavingsPlansUtilizationDetails(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSavingsPlansUtilizationDetailsResult executeGetSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSavingsPlansUtilizationDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSavingsPlansUtilizationDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSavingsPlansUtilizationDetailsRequestProtocolMarshaller(protocolFactory).marshall((GetSavingsPlansUtilizationDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSavingsPlansUtilizationDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSavingsPlansUtilizationDetails");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSavingsPlansUtilizationDetailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSavingsPlansUtilizationDetailsResult getSavingsPlansUtilizationDetailsResult = (GetSavingsPlansUtilizationDetailsResult)response.getAwsResponse();
            return getSavingsPlansUtilizationDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTagsResult getTags(GetTagsRequest request) {
        request = (GetTagsRequest)this.beforeClientExecution(request);
        return this.executeGetTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTagsResult executeGetTags(GetTagsRequest getTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTagsRequestProtocolMarshaller(protocolFactory).marshall((GetTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTagsResult getTagsResult = (GetTagsResult)response.getAwsResponse();
            return getTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetUsageForecastResult getUsageForecast(GetUsageForecastRequest request) {
        request = (GetUsageForecastRequest)this.beforeClientExecution(request);
        return this.executeGetUsageForecast(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetUsageForecastResult executeGetUsageForecast(GetUsageForecastRequest getUsageForecastRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getUsageForecastRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetUsageForecastRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetUsageForecastRequestProtocolMarshaller(protocolFactory).marshall((GetUsageForecastRequest)super.beforeMarshalling((AmazonWebServiceRequest)getUsageForecastRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetUsageForecast");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetUsageForecastResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetUsageForecastResult getUsageForecastResult = (GetUsageForecastResult)response.getAwsResponse();
            return getUsageForecastResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCostCategoryDefinitionsResult listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest request) {
        request = (ListCostCategoryDefinitionsRequest)this.beforeClientExecution(request);
        return this.executeListCostCategoryDefinitions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCostCategoryDefinitionsResult executeListCostCategoryDefinitions(ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCostCategoryDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCostCategoryDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCostCategoryDefinitionsRequestProtocolMarshaller(protocolFactory).marshall((ListCostCategoryDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCostCategoryDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCostCategoryDefinitions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCostCategoryDefinitionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCostCategoryDefinitionsResult listCostCategoryDefinitionsResult = (ListCostCategoryDefinitionsResult)response.getAwsResponse();
            return listCostCategoryDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateCostCategoryDefinitionResult updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest request) {
        request = (UpdateCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executeUpdateCostCategoryDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateCostCategoryDefinitionResult executeUpdateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest updateCostCategoryDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateCostCategoryDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateCostCategoryDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateCostCategoryDefinitionRequestProtocolMarshaller(protocolFactory).marshall((UpdateCostCategoryDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateCostCategoryDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Explorer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateCostCategoryDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateCostCategoryDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateCostCategoryDefinitionResult updateCostCategoryDefinitionResult = (UpdateCostCategoryDefinitionResult)response.getAwsResponse();
            return updateCostCategoryDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

