/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.costexplorer.AWSCostExplorerAsync;
import com.amazonaws.services.costexplorer.AWSCostExplorerAsyncClientBuilder;
import com.amazonaws.services.costexplorer.AWSCostExplorerClient;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageRequest;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageResult;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesRequest;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesResult;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageRequest;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageResult;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationResult;
import com.amazonaws.services.costexplorer.model.GetTagsRequest;
import com.amazonaws.services.costexplorer.model.GetTagsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCostExplorerAsyncClient
extends AWSCostExplorerClient
implements AWSCostExplorerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCostExplorerAsyncClientBuilder asyncBuilder() {
        return AWSCostExplorerAsyncClientBuilder.standard();
    }

    AWSCostExplorerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetCostAndUsageResult> getCostAndUsageAsync(GetCostAndUsageRequest request) {
        return this.getCostAndUsageAsync(request, null);
    }

    @Override
    public Future<GetCostAndUsageResult> getCostAndUsageAsync(GetCostAndUsageRequest request, final AsyncHandler<GetCostAndUsageRequest, GetCostAndUsageResult> asyncHandler) {
        final GetCostAndUsageRequest finalRequest = (GetCostAndUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostAndUsageResult>(){

            @Override
            public GetCostAndUsageResult call() throws Exception {
                GetCostAndUsageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetCostAndUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDimensionValuesResult> getDimensionValuesAsync(GetDimensionValuesRequest request) {
        return this.getDimensionValuesAsync(request, null);
    }

    @Override
    public Future<GetDimensionValuesResult> getDimensionValuesAsync(GetDimensionValuesRequest request, final AsyncHandler<GetDimensionValuesRequest, GetDimensionValuesResult> asyncHandler) {
        final GetDimensionValuesRequest finalRequest = (GetDimensionValuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDimensionValuesResult>(){

            @Override
            public GetDimensionValuesResult call() throws Exception {
                GetDimensionValuesResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetDimensionValues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationCoverageResult> getReservationCoverageAsync(GetReservationCoverageRequest request) {
        return this.getReservationCoverageAsync(request, null);
    }

    @Override
    public Future<GetReservationCoverageResult> getReservationCoverageAsync(GetReservationCoverageRequest request, final AsyncHandler<GetReservationCoverageRequest, GetReservationCoverageResult> asyncHandler) {
        final GetReservationCoverageRequest finalRequest = (GetReservationCoverageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationCoverageResult>(){

            @Override
            public GetReservationCoverageResult call() throws Exception {
                GetReservationCoverageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationCoverage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationPurchaseRecommendationResult> getReservationPurchaseRecommendationAsync(GetReservationPurchaseRecommendationRequest request) {
        return this.getReservationPurchaseRecommendationAsync(request, null);
    }

    @Override
    public Future<GetReservationPurchaseRecommendationResult> getReservationPurchaseRecommendationAsync(GetReservationPurchaseRecommendationRequest request, final AsyncHandler<GetReservationPurchaseRecommendationRequest, GetReservationPurchaseRecommendationResult> asyncHandler) {
        final GetReservationPurchaseRecommendationRequest finalRequest = (GetReservationPurchaseRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationPurchaseRecommendationResult>(){

            @Override
            public GetReservationPurchaseRecommendationResult call() throws Exception {
                GetReservationPurchaseRecommendationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationPurchaseRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationUtilizationResult> getReservationUtilizationAsync(GetReservationUtilizationRequest request) {
        return this.getReservationUtilizationAsync(request, null);
    }

    @Override
    public Future<GetReservationUtilizationResult> getReservationUtilizationAsync(GetReservationUtilizationRequest request, final AsyncHandler<GetReservationUtilizationRequest, GetReservationUtilizationResult> asyncHandler) {
        final GetReservationUtilizationRequest finalRequest = (GetReservationUtilizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationUtilizationResult>(){

            @Override
            public GetReservationUtilizationResult call() throws Exception {
                GetReservationUtilizationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationUtilization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request) {
        return this.getTagsAsync(request, null);
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request, final AsyncHandler<GetTagsRequest, GetTagsResult> asyncHandler) {
        final GetTagsRequest finalRequest = (GetTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTagsResult>(){

            @Override
            public GetTagsResult call() throws Exception {
                GetTagsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

