/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContextImpl;
import com.amazonaws.transform.rpcv2cbor.VoidRpcV2CborUnmarshaller;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.ValidationUtils;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class RpcV2CborResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, RpcV2CborUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private final CBORFactory cborFactory;
    private final boolean needsConnectionLeftOpen;
    private final boolean isPayloadRpcV2Cbor;
    private final Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> simpleTypeUnmarshallers;
    private final Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customTypeMarshallers;

    public RpcV2CborResponseHandler(Unmarshaller<T, RpcV2CborUnmarshallerContext> responseUnmarshaller, Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> simpleTypeUnmarshallers, Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customTypeMarshallers, CBORFactory cborFactory, boolean needsConnectionLeftOpen, boolean isPayloadRpcV2Cbor) {
        this.responseUnmarshaller = responseUnmarshaller != null ? responseUnmarshaller : new VoidRpcV2CborUnmarshaller();
        this.needsConnectionLeftOpen = needsConnectionLeftOpen;
        this.isPayloadRpcV2Cbor = isPayloadRpcV2Cbor;
        this.simpleTypeUnmarshallers = ValidationUtils.assertNotNull(simpleTypeUnmarshallers, "simple type unmarshallers");
        this.customTypeMarshallers = ValidationUtils.assertNotNull(customTypeMarshallers, "custom type marshallers");
        this.cborFactory = ValidationUtils.assertNotNull(cborFactory, "cborFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        log.trace((Object)"Parsing service response RPCV2CBOR");
        String crc32Checksum = response.getHeaders().get("x-amz-crc32");
        CBORParser cborParser = null;
        if (this.shouldParsePayloadAsRpcV2Cbor()) {
            cborParser = this.cborFactory.createParser(response.getContent());
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            RpcV2CborUnmarshallerContextImpl unmarshallerContext = new RpcV2CborUnmarshallerContextImpl(cborParser, this.simpleTypeUnmarshallers, this.customTypeMarshallers, response);
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            if (this.shouldParsePayloadAsRpcV2Cbor() && response.getContent() != null) {
                IOUtils.drainInputStream(response.getContent());
            }
            if (crc32Checksum != null) {
                long serverSideCRC = Long.parseLong(crc32Checksum);
                long clientSideCRC = response.getCRC32Checksum();
                if (clientSideCRC != serverSideCRC) {
                    throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side");
                }
            }
            awsResponse.setResult(result);
            Map<String, String> metadata = ((RpcV2CborUnmarshallerContext)unmarshallerContext).getMetadata();
            metadata.put("AWS_REQUEST_ID", response.getHeaders().get("x-amzn-RequestId"));
            awsResponse.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        finally {
            if (this.shouldParsePayloadAsRpcV2Cbor()) {
                try {
                    cborParser.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing rpcv2Cbor parser", (Throwable)e);
                }
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(RpcV2CborUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    private boolean shouldParsePayloadAsRpcV2Cbor() {
        return !this.needsConnectionLeftOpen && this.isPayloadRpcV2Cbor;
    }
}

