/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform.rpcv2cbor;

import com.amazonaws.http.HttpResponse;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class RpcV2CborUnmarshallerContextImpl
extends RpcV2CborUnmarshallerContext {
    private JsonToken currentToken;
    private JsonToken nextToken;
    private final CBORParser cborParser;
    private String currentHeader;
    private final Stack<CborFieldTokenPair> stack = new Stack();
    private String currentField;
    private String lastParsedParentElement;
    private Map<String, String> metadata = new HashMap<String, String>();
    private final HttpResponse httpResponse;
    private final Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> unmarshallerMap;
    private final Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customUnmarshallerMap;

    public RpcV2CborUnmarshallerContextImpl(CBORParser cborParser, Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> mapper, HttpResponse httpResponse) {
        this(cborParser, mapper, Collections.emptyMap(), httpResponse);
    }

    public RpcV2CborUnmarshallerContextImpl(CBORParser cborParser, Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> mapper, Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customUnmarshallerMap, HttpResponse httpResponse) {
        this.cborParser = cborParser;
        this.unmarshallerMap = mapper;
        this.customUnmarshallerMap = customUnmarshallerMap;
        this.httpResponse = httpResponse;
    }

    @Override
    public String getHeader(String header) {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.getHeaders().get(header);
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public int getCurrentDepth() {
        int depth = this.stack.size();
        if (this.currentField != null) {
            ++depth;
        }
        return depth;
    }

    @Override
    public String readText() throws IOException {
        if (this.isInsideResponseHeader()) {
            return this.getHeader(this.currentHeader);
        }
        return this.readCurrentJsonTokenValue();
    }

    private String readCurrentJsonTokenValue() throws IOException {
        switch (this.currentToken) {
            case VALUE_STRING: {
                String text = this.cborParser.getText();
                return text;
            }
            case VALUE_FALSE: {
                return "false";
            }
            case VALUE_TRUE: {
                return "true";
            }
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return this.cborParser.getNumberValue().toString();
            }
            case FIELD_NAME: {
                return this.cborParser.getText();
            }
        }
        throw new RuntimeException("We expected a VALUE token but got: " + this.currentToken);
    }

    @Override
    public boolean isInsideResponseHeader() {
        return this.currentToken == null && this.nextToken == null;
    }

    @Override
    public boolean isStartOfDocument() {
        return this.cborParser == null || this.cborParser.getCurrentToken() == null;
    }

    @Override
    public boolean testExpression(String expression) {
        if (expression.equals(".")) {
            return true;
        }
        if (this.currentField != null) {
            return this.currentField.equals(expression);
        }
        return !this.stack.isEmpty() && this.stack.peek().getField().equals(expression);
    }

    @Override
    public String getCurrentParentElement() {
        String parentElement = this.currentField != null ? this.currentField : (!this.stack.isEmpty() ? this.stack.peek().getField() : "");
        return parentElement;
    }

    @Override
    public boolean testExpression(String expression, int stackDepth) {
        if (expression.equals(".")) {
            return true;
        }
        return this.testExpression(expression) && stackDepth == this.getCurrentDepth();
    }

    @Override
    public JsonToken nextToken() throws IOException {
        JsonToken token;
        this.currentToken = token = this.nextToken != null ? this.nextToken : this.cborParser.nextToken();
        this.nextToken = null;
        this.updateContext();
        return token;
    }

    @Override
    public JsonToken peek() throws IOException {
        if (this.nextToken != null) {
            return this.nextToken;
        }
        this.nextToken = this.cborParser.nextToken();
        return this.nextToken;
    }

    @Override
    public CBORParser getCBORParser() {
        return this.cborParser;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setCurrentHeader(String currentHeader) {
        this.currentHeader = currentHeader;
    }

    @Override
    public <T> Unmarshaller<T, RpcV2CborUnmarshallerContext> getUnmarshaller(Class<T> type) {
        return this.unmarshallerMap.get(type);
    }

    @Override
    public <T> Unmarshaller<T, RpcV2CborUnmarshallerContext> getUnmarshaller(Class<T> type, RpcV2CborUnmarshallerContext.UnmarshallerType unmarshallerType) {
        return this.customUnmarshallerMap.get((Object)unmarshallerType);
    }

    @Override
    public JsonToken getCurrentToken() {
        return this.currentToken;
    }

    private void updateContext() throws IOException {
        this.lastParsedParentElement = null;
        if (this.currentToken == null) {
            return;
        }
        if (this.currentToken == JsonToken.START_OBJECT || this.currentToken == JsonToken.START_ARRAY) {
            if (this.currentField != null) {
                this.stack.push(new CborFieldTokenPair(this.currentField, this.currentToken));
                this.currentField = null;
            } else if (this.currentToken == JsonToken.START_ARRAY) {
                this.stack.push(new CborFieldTokenPair("ARRAY", this.currentToken));
            }
        } else if (this.currentToken == JsonToken.END_OBJECT || this.currentToken == JsonToken.END_ARRAY) {
            if (!this.stack.isEmpty()) {
                boolean curlyBracketsMatch;
                boolean squareBracketsMatch = this.currentToken == JsonToken.END_ARRAY && this.stack.peek().getToken() == JsonToken.START_ARRAY;
                boolean bl = curlyBracketsMatch = this.currentToken == JsonToken.END_OBJECT && this.stack.peek().getToken() == JsonToken.START_OBJECT;
                if (squareBracketsMatch || curlyBracketsMatch) {
                    this.lastParsedParentElement = this.stack.pop().getField();
                }
            }
            this.currentField = null;
        } else if (this.currentToken == JsonToken.FIELD_NAME) {
            String t;
            this.currentField = t = this.cborParser.getText();
        }
    }

    public String toString() {
        StringBuilder stackString = new StringBuilder();
        for (CborFieldTokenPair cborFieldTokenPair : this.stack) {
            stackString.append("/").append(cborFieldTokenPair.getField());
        }
        if (this.currentField != null) {
            stackString.append("/").append(this.currentField);
        }
        return stackString.length() == 0 ? "/" : stackString.toString();
    }

    @Override
    public String getLastParsedParentElement() {
        return this.lastParsedParentElement;
    }

    private static class CborFieldTokenPair {
        private final String field;
        private final JsonToken cborToken;

        public CborFieldTokenPair(String fieldString, JsonToken token) {
            this.field = fieldString;
            this.cborToken = token;
        }

        public String getField() {
            return this.field;
        }

        public JsonToken getToken() {
            return this.cborToken;
        }

        public String toString() {
            return this.field + ": " + this.cborToken.asString();
        }
    }
}

