/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.controltower.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/controltower-2018-05-10/GetEnabledControl" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetEnabledControlResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Information about the enabled control.
     * </p>
     */
    private EnabledControlDetails enabledControlDetails;

    /**
     * <p>
     * Information about the enabled control.
     * </p>
     * 
     * @param enabledControlDetails
     *        Information about the enabled control.
     */

    public void setEnabledControlDetails(EnabledControlDetails enabledControlDetails) {
        this.enabledControlDetails = enabledControlDetails;
    }

    /**
     * <p>
     * Information about the enabled control.
     * </p>
     * 
     * @return Information about the enabled control.
     */

    public EnabledControlDetails getEnabledControlDetails() {
        return this.enabledControlDetails;
    }

    /**
     * <p>
     * Information about the enabled control.
     * </p>
     * 
     * @param enabledControlDetails
     *        Information about the enabled control.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetEnabledControlResult withEnabledControlDetails(EnabledControlDetails enabledControlDetails) {
        setEnabledControlDetails(enabledControlDetails);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnabledControlDetails() != null)
            sb.append("EnabledControlDetails: ").append(getEnabledControlDetails());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetEnabledControlResult == false)
            return false;
        GetEnabledControlResult other = (GetEnabledControlResult) obj;
        if (other.getEnabledControlDetails() == null ^ this.getEnabledControlDetails() == null)
            return false;
        if (other.getEnabledControlDetails() != null && other.getEnabledControlDetails().equals(this.getEnabledControlDetails()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnabledControlDetails() == null) ? 0 : getEnabledControlDetails().hashCode());
        return hashCode;
    }

    @Override
    public GetEnabledControlResult clone() {
        try {
            return (GetEnabledControlResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
